/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.model;

import java.io.ObjectStreamException;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.URIUtil;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lmdb.ValueStoreRevision;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbResource;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LmdbIRI
implements LmdbResource,
IRI {
    private static final long serialVersionUID = -5888138591826143179L;
    private static final Logger log = LoggerFactory.getLogger(LmdbIRI.class);
    private ValueStoreRevision revision;
    private long internalID;
    private boolean initialized = false;
    private String iriString;
    private int localNameIdx;

    public LmdbIRI(ValueStoreRevision revision, long internalID) {
        this.setInternalID(internalID, revision);
    }

    public LmdbIRI(ValueStoreRevision revision, String uri) {
        this(revision, uri, -1L);
    }

    public LmdbIRI(ValueStoreRevision revision, String uri, long internalID) {
        this.setIRIString(uri);
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    public LmdbIRI(ValueStoreRevision revision, String namespace, String localName) {
        this(revision, namespace, localName, -1L);
    }

    public LmdbIRI(ValueStoreRevision revision, String namespace, String localName, long internalID) {
        this.revision = revision;
        this.setNamespaceAndIri(namespace, localName);
        this.setInternalID(internalID, revision);
    }

    @Override
    public void setInternalID(long internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public void setFromInitializedValue(LmdbValue initializedValue) {
        if (!(initializedValue instanceof LmdbIRI)) {
            throw new SailException("Trying to initialize LmdbIRI from non-IRI value");
        }
        LmdbIRI initializedIRI = (LmdbIRI)initializedValue;
        this.iriString = initializedIRI.iriString;
        this.localNameIdx = initializedIRI.localNameIdx;
    }

    @Override
    public long getInternalID() {
        return this.internalID;
    }

    private void setIRIString(String iriString) {
        Objects.requireNonNull(iriString, "iriString must not be null");
        if (iriString.indexOf(58) < 0) {
            throw new IllegalArgumentException("Not a valid (absolute) IRI: " + iriString);
        }
        this.iriString = iriString;
        this.localNameIdx = -1;
    }

    public String getNamespace() {
        this.init();
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex((String)this.iriString);
        }
        return this.iriString.substring(0, this.localNameIdx);
    }

    public String getLocalName() {
        this.init();
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex((String)this.iriString);
        }
        return this.iriString.substring(this.localNameIdx);
    }

    public String stringValue() {
        if (this.iriString != null) {
            return this.iriString;
        }
        this.init();
        return this.iriString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.iriString == null && !this.initialized) {
            LmdbIRI lmdbIRI = this;
            synchronized (lmdbIRI) {
                if (!this.initialized) {
                    boolean resolved = this.revision.resolveValue(this.internalID, this);
                    if (!resolved) {
                        log.warn("Could not resolve value");
                    }
                    this.initialized = resolved;
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == LmdbIRI.class) {
            if (this.internalID == -1L) {
                boolean equals = this.stringValue().equals(((IRI)o).stringValue());
                if (equals && this.revision.equals(((LmdbIRI)o).revision)) {
                    this.internalID = ((LmdbIRI)o).internalID;
                }
                return equals;
            }
            LmdbIRI otherLmdbURI = (LmdbIRI)o;
            if (this.revision.equals(otherLmdbURI.revision)) {
                boolean equal;
                if (otherLmdbURI.internalID == -1L) {
                    boolean equals = this.stringValue().equals(((IRI)o).stringValue());
                    if (equals) {
                        otherLmdbURI.internalID = this.internalID;
                    }
                    return equals;
                }
                boolean bl = equal = this.internalID == otherLmdbURI.internalID;
                if (equal) {
                    if (this.iriString == null) {
                        this.iriString = otherLmdbURI.iriString;
                        this.localNameIdx = otherLmdbURI.localNameIdx;
                    } else if (otherLmdbURI.iriString == null) {
                        otherLmdbURI.iriString = this.iriString;
                        otherLmdbURI.localNameIdx = this.localNameIdx;
                    }
                }
                return equal;
            }
        }
        if (!(o instanceof IRI)) {
            return false;
        }
        return this.stringValue().equals(((IRI)o).stringValue());
    }

    public int hashCode() {
        if (this.iriString != null) {
            return this.iriString.hashCode();
        }
        this.init();
        return this.iriString.hashCode();
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.init();
        return this;
    }

    public String toString() {
        return this.stringValue();
    }

    public void setNamespaceAndIri(String namespace, String localName) {
        this.localNameIdx = namespace.length();
        this.iriString = namespace + localName;
    }
}

