/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.repository.handler.QueryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.handler.RepositoryRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class AbstractRepositoryController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public AbstractRepositoryController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "HEAD"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug("Request method: {}", (Object)request.getMethod());
        RequestMethod requestMethod = RequestMethod.valueOf((String)request.getMethod());
        switch (requestMethod) {
            case DELETE: {
                this.logger.debug("handleDeleteRepositoryRequest");
                return this.getRepositoryRequestHandler().handleDeleteRepositoryRequest(request);
            }
            case PUT: {
                this.logger.debug("handleCreateOrUpdateRepositoryRequest");
                return this.getRepositoryRequestHandler().handleCreateOrUpdateRepositoryRequest(request);
            }
        }
        this.logger.debug("handleQueryRequest");
        return this.getQueryRequestHandler().handleQueryRequest(request, requestMethod, response);
    }

    protected abstract QueryRequestHandler getQueryRequestHandler();

    protected abstract RepositoryRequestHandler getRepositoryRequestHandler();
}

