/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.federation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.SilentIteration;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.JoinExecutorBase;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLCrossProductIteration;
import org.eclipse.rdf4j.repository.sparql.federation.ServiceJoinConversionIteration;
import org.eclipse.rdf4j.repository.sparql.query.InsertBindingSetCursor;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFederatedService
implements FederatedService {
    private static final String ROW_IDX_VAR = "__rowIdx";
    static final Logger logger = LoggerFactory.getLogger(RepositoryFederatedService.class);
    private final Repository rep;
    protected int boundJoinBlockSize = 15;
    private boolean useFreshConnection = true;
    protected boolean shutDown;
    private RepositoryConnection managedConn = null;

    public RepositoryFederatedService(Repository repo) {
        this(repo, true);
    }

    public RepositoryFederatedService(Repository repo, boolean shutDown) {
        this.rep = repo;
        this.shutDown = shutDown;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> select(Service service, Set<String> projectionVars, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        RepositoryConnection conn = null;
        try {
            String sparqlQueryString = service.getSelectQueryString(projectionVars);
            conn = this.useFreshConnection ? this.freshConnection() : this.getConnection();
            TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
            for (Binding b : bindings) {
                if (!service.getServiceVars().contains(b.getName())) continue;
                query.setBinding(b.getName(), b.getValue());
            }
            TupleQueryResult res = query.evaluate();
            Object result = new InsertBindingSetCursor((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
            if (this.useFreshConnection) {
                result = new CloseConnectionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result, conn);
            }
            if (service.isSilent()) {
                return new SilentIteration((CloseableIteration)result);
            }
            return result;
        }
        catch (MalformedQueryException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            throw new QueryEvaluationException((Throwable)e);
        }
        catch (RepositoryException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ask(Service service, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        boolean bl;
        block7: {
            RepositoryConnection conn = null;
            try {
                String sparqlQueryString = service.getAskQueryString();
                conn = this.useFreshConnection ? this.freshConnection() : this.getConnection();
                BooleanQuery query = conn.prepareBooleanQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
                for (Binding b : bindings) {
                    if (!service.getServiceVars().contains(b.getName())) continue;
                    query.setBinding(b.getName(), b.getValue());
                }
                bl = query.evaluate();
                if (!this.useFreshConnection) break block7;
            }
            catch (MalformedQueryException e) {
                try {
                    throw new QueryEvaluationException((Throwable)e);
                    catch (RepositoryException e2) {
                        throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (this.useFreshConnection) {
                        RepositoryFederatedService.closeQuietly(conn);
                    }
                    throw throwable;
                }
            }
            RepositoryFederatedService.closeQuietly(conn);
        }
        return bl;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        if (this.boundJoinBlockSize > 0) {
            return new BatchingServiceIteration(bindings, this.boundJoinBlockSize, service);
        }
        return this.evaluateInternal(service, bindings, service.getBaseURI());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternal(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        LinkedList<BindingSet> allBindings = new LinkedList<BindingSet>();
        while (bindings.hasNext()) {
            allBindings.add((BindingSet)bindings.next());
        }
        if (allBindings.isEmpty()) {
            return new EmptyIteration();
        }
        HashSet<String> projectionVars = new HashSet<String>(service.getServiceVars());
        projectionVars.removeAll(((BindingSet)allBindings.get(0)).getBindingNames());
        RepositoryConnection conn = null;
        Object result = null;
        try {
            if (allBindings.size() == 1) {
                result = this.select(service, projectionVars, (BindingSet)allBindings.get(0), baseUri);
                result = service.isSilent() ? new SilentIteration((CloseableIteration)result) : result;
                return result;
            }
            projectionVars.add(ROW_IDX_VAR);
            String queryString = service.getSelectQueryString(projectionVars);
            List<String> relevantBindingNames = this.getRelevantBindingNames(allBindings, service.getServiceVars());
            if (!relevantBindingNames.isEmpty()) {
                queryString = this.insertValuesClause(queryString, this.buildVALUESClause(allBindings, relevantBindingNames));
            }
            conn = this.useFreshConnection ? this.freshConnection() : this.getConnection();
            TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, queryString, baseUri);
            query.setMaxExecutionTime(60);
            TupleQueryResult res = query.evaluate();
            result = relevantBindingNames.isEmpty() ? new SPARQLCrossProductIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings) : new ServiceJoinConversionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, allBindings);
            if (this.useFreshConnection) {
                result = new CloseConnectionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result, conn);
            }
            result = service.isSilent() ? new SilentIteration((CloseableIteration)result) : result;
            return result;
        }
        catch (RepositoryException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", (Throwable)e);
        }
        catch (MalformedQueryException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            logger.debug("Encounted malformed query exception: " + e.getMessage() + ". Falling back to simple SERVICE evaluation.");
            return this.evaluateInternalFallback(service, allBindings, baseUri);
        }
        catch (QueryEvaluationException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.useFreshConnection) {
                RepositoryFederatedService.closeQuietly(conn);
            }
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration(allBindings);
            }
            throw e;
        }
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternalFallback(Service service, List<BindingSet> allBindings, String baseUri) {
        FallbackServiceIteration res = new FallbackServiceIteration(service, allBindings, baseUri);
        if (service.isSilent()) {
            res = new SilentIteration((CloseableIteration)res);
        }
        return res;
    }

    protected String insertValuesClause(String queryString, String valuesClause) {
        StringBuilder sb = new StringBuilder(queryString);
        if (sb.indexOf(ROW_IDX_VAR) == -1 && sb.indexOf("SELECT * ") == -1) {
            sb.insert(sb.indexOf("SELECT") + 6, " ?__rowIdx");
        }
        sb.insert(sb.indexOf("{") + 1, " " + valuesClause);
        return sb.toString();
    }

    public void initialize() throws QueryEvaluationException {
        try {
            this.rep.init();
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.rep.isInitialized();
    }

    public int getBoundJoinBlockSize() {
        return this.boundJoinBlockSize;
    }

    public void setBoundJoinBlockSize(int boundJoinBlockSize) {
        this.boundJoinBlockSize = boundJoinBlockSize;
    }

    public void setUseFreshConnection(boolean flag) {
        this.useFreshConnection = flag;
    }

    public void shutdown() throws QueryEvaluationException {
        boolean foundException = false;
        try {
            if (this.managedConn != null) {
                this.managedConn.close();
            }
        }
        catch (RepositoryException e) {
            foundException = true;
            throw new QueryEvaluationException((Throwable)e);
        }
        finally {
            block12: {
                try {
                    if (this.shutDown) {
                        this.rep.shutDown();
                    }
                }
                catch (RepositoryException e) {
                    if (foundException) break block12;
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
        }
    }

    private RepositoryConnection freshConnection() throws RepositoryException {
        return this.rep.getConnection();
    }

    protected synchronized RepositoryConnection getConnection() throws RepositoryException {
        if (this.managedConn == null) {
            this.managedConn = this.freshConnection();
        }
        return this.managedConn;
    }

    private List<String> getRelevantBindingNames(List<BindingSet> bindings, Set<String> serviceVars) {
        ArrayList<String> relevantBindingNames = new ArrayList<String>(5);
        for (String bName : bindings.get(0).getBindingNames()) {
            if (!serviceVars.contains(bName)) continue;
            relevantBindingNames.add(bName);
        }
        return relevantBindingNames;
    }

    private String buildVALUESClause(List<BindingSet> bindings, List<String> relevantBindingNames) throws QueryEvaluationException {
        StringBuilder sb = new StringBuilder();
        sb.append(" VALUES (?__rowIdx");
        for (String bName : relevantBindingNames) {
            sb.append(" ?").append(bName);
        }
        sb.append(") { ");
        int rowIdx = 0;
        for (BindingSet b : bindings) {
            sb.append(" (");
            sb.append("\"").append(rowIdx++).append("\" ");
            for (String bName : relevantBindingNames) {
                QueryStringUtil.appendValueAsString(sb, b.getValue(bName)).append(" ");
            }
            sb.append(")");
        }
        sb.append(" }");
        return sb.toString();
    }

    private static void closeQuietly(RepositoryConnection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Throwable t) {
            logger.warn("Failed to close connection:" + t.getMessage());
            logger.debug("Details: ", t);
        }
    }

    private static class CloseConnectionIteration
    implements CloseableIteration<BindingSet, QueryEvaluationException> {
        private final CloseableIteration<BindingSet, QueryEvaluationException> delegate;
        private final RepositoryConnection connection;

        private CloseConnectionIteration(CloseableIteration<BindingSet, QueryEvaluationException> delegate, RepositoryConnection connection) {
            this.delegate = delegate;
            this.connection = connection;
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this.delegate.hasNext();
        }

        public BindingSet next() throws QueryEvaluationException {
            return (BindingSet)this.delegate.next();
        }

        public void remove() throws QueryEvaluationException {
            this.delegate.remove();
        }

        public void close() throws QueryEvaluationException {
            try {
                this.delegate.close();
            }
            finally {
                RepositoryFederatedService.closeQuietly(this.connection);
            }
        }
    }

    private class FallbackServiceIteration
    extends JoinExecutorBase<BindingSet> {
        private final Service service;
        private final List<BindingSet> allBindings;
        private final String baseUri;

        public FallbackServiceIteration(Service service, List<BindingSet> allBindings, String baseUri) {
            super(null, null, null);
            this.service = service;
            this.allBindings = allBindings;
            this.baseUri = baseUri;
            this.run();
        }

        @Override
        protected void handleBindings() throws Exception {
            HashSet<String> projectionVars = new HashSet<String>(this.service.getServiceVars());
            for (BindingSet b : this.allBindings) {
                this.addResult(RepositoryFederatedService.this.select(this.service, projectionVars, b, this.baseUri));
            }
        }
    }

    private class BatchingServiceIteration
    extends JoinExecutorBase<BindingSet> {
        private final int blockSize;
        private final Service service;

        public BatchingServiceIteration(CloseableIteration<BindingSet, QueryEvaluationException> inputBindings, int blockSize, Service service) throws QueryEvaluationException {
            super(inputBindings, null, EmptyBindingSet.getInstance());
            this.blockSize = blockSize;
            this.service = service;
            this.run();
        }

        @Override
        protected void handleBindings() throws Exception {
            while (!this.isClosed() && this.leftIter.hasNext()) {
                ArrayList<BindingSet> blockBindings = new ArrayList<BindingSet>(this.blockSize);
                for (int i = 0; i < this.blockSize && this.leftIter.hasNext(); ++i) {
                    blockBindings.add((BindingSet)this.leftIter.next());
                }
                CollectionIteration materializedIter = new CollectionIteration(blockBindings);
                this.addResult(RepositoryFederatedService.this.evaluateInternal(this.service, (CloseableIteration<BindingSet, QueryEvaluationException>)materializedIter, this.service.getBaseURI()));
            }
        }
    }
}

