/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.Queue;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class PathIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private long currentLength;
    private CloseableIteration<BindingSet, QueryEvaluationException> currentIter;
    private final BindingSet bindings;
    private final StatementPattern.Scope scope;
    private final Var startVar;
    private final Var endVar;
    private final boolean startVarFixed;
    private final boolean endVarFixed;
    private final Queue<ValuePair> valueQueue;
    private final Set<ValuePair> reportedValues;
    private final Set<ValuePair> unreportedValues;
    private final TupleExpr pathExpression;
    private final Var contextVar;
    private ValuePair currentVp;
    private static final String JOINVAR_PREFIX = "intermediate_join_";

    public PathIteration(EvaluationStrategy strategy, StatementPattern.Scope scope, Var startVar, TupleExpr pathExpression, Var endVar, Var contextVar, long minLength, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.scope = scope;
        this.startVar = startVar;
        this.endVar = endVar;
        this.startVarFixed = startVar.hasValue() || bindings.hasBinding(startVar.getName());
        this.endVarFixed = endVar.hasValue() || bindings.hasBinding(endVar.getName());
        this.pathExpression = pathExpression;
        this.contextVar = contextVar;
        this.currentLength = minLength;
        this.bindings = bindings;
        this.reportedValues = strategy.makeSet();
        this.unreportedValues = strategy.makeSet();
        this.valueQueue = strategy.makeQueue();
        this.createIteration();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        ValuePair vp;
        Value v2;
        Value v1;
        MutableBindingSet nextElement;
        block0: while (true) {
            if (!this.currentIter.hasNext()) {
                Iterations.closeCloseable(this.currentIter);
                this.createIteration();
                if (!(this.currentIter instanceof EmptyIteration)) continue;
            }
            while (true) {
                Value startValue;
                if (!this.currentIter.hasNext()) {
                    this.reportedValues.clear();
                    this.unreportedValues.clear();
                    this.valueQueue.clear();
                    return null;
                }
                BindingSet potentialNextElement = (BindingSet)this.currentIter.next();
                nextElement = potentialNextElement instanceof QueryBindingSet ? (MutableBindingSet)potentialNextElement : new QueryBindingSet(potentialNextElement);
                if (!this.startVarFixed && !this.endVarFixed && this.currentVp != null && (startValue = this.currentVp.getStartValue()) != null) {
                    nextElement = new QueryBindingSet(nextElement);
                    this.addBinding(nextElement, this.startVar.getName(), startValue);
                }
                if (this.startVarFixed && this.endVarFixed && this.currentLength > 2L) {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                    v2 = nextElement.getValue("END_intermediate_join_" + this.hashCode());
                } else if (this.startVarFixed && this.endVarFixed && this.currentLength == 2L) {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                    v2 = nextElement.getValue(JOINVAR_PREFIX + (this.currentLength - 1L) + "_" + this.hashCode());
                } else {
                    v1 = this.getVarValue(this.startVar, this.startVarFixed, nextElement);
                    v2 = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
                }
                if (this.isCyclicPath(v1, v2)) continue block0;
                vp = new ValuePair(v1, v2);
                if (!this.reportedValues.contains(vp)) break;
                if (!this.currentIter.hasNext()) continue block0;
            }
            if (!this.startVarFixed || !this.endVarFixed) break;
            Value endValue = this.getVarValue(this.endVar, this.endVarFixed, nextElement);
            if (endValue.equals(v2)) {
                this.add(this.reportedValues, vp);
                if (!v1.equals(v2)) {
                    this.addToQueue(this.valueQueue, vp);
                }
                if (!nextElement.hasBinding(this.startVar.getName())) {
                    this.addBinding(nextElement, this.startVar.getName(), v1);
                }
                if (!nextElement.hasBinding(this.endVar.getName())) {
                    this.addBinding(nextElement, this.endVar.getName(), v2);
                }
                return nextElement;
            }
            if (!this.add(this.unreportedValues, vp) || v1.equals(v2)) continue;
            this.addToQueue(this.valueQueue, vp);
        }
        this.add(this.reportedValues, vp);
        if (!v1.equals(v2)) {
            this.addToQueue(this.valueQueue, vp);
        }
        if (!nextElement.hasBinding(this.startVar.getName())) {
            this.addBinding(nextElement, this.startVar.getName(), v1);
        }
        if (!nextElement.hasBinding(this.endVar.getName())) {
            this.addBinding(nextElement, this.endVar.getName(), v2);
        }
        return nextElement;
    }

    private void addBinding(MutableBindingSet bs, String name, Value value) {
        bs.addBinding(name, value);
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            Iterations.closeCloseable(this.currentIter);
        }
    }

    protected boolean addToQueue(Queue<ValuePair> valueQueue2, ValuePair vp) throws QueryEvaluationException {
        return valueQueue2.add(vp);
    }

    protected boolean add(Set<ValuePair> valueSet, ValuePair vp) throws QueryEvaluationException {
        return valueSet.add(vp);
    }

    private Value getVarValue(Var var, boolean fixedValue, BindingSet bindingSet) {
        Value v;
        if (fixedValue) {
            v = var.getValue();
            if (v == null) {
                v = this.bindings.getValue(var.getName());
            }
        } else {
            v = bindingSet.getValue(var.getName());
        }
        return v;
    }

    private boolean isCyclicPath(Value v1, Value v2) {
        if (this.currentLength <= 2L) {
            return false;
        }
        return this.reportedValues.contains(new ValuePair(v1, v2));
    }

    private void createIteration() throws QueryEvaluationException {
        if (this.isUnbound(this.startVar, this.bindings) || this.isUnbound(this.endVar, this.bindings)) {
            this.currentIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
        } else if (this.currentLength == 0L) {
            ZeroLengthPath zlp = new ZeroLengthPath(this.scope, this.startVar.clone(), this.endVar.clone(), this.contextVar != null ? this.contextVar.clone() : null);
            this.currentIter = this.strategy.evaluate(zlp, this.bindings);
            ++this.currentLength;
        } else if (this.currentLength == 1L) {
            TupleExpr pathExprClone = this.pathExpression.clone();
            if (this.startVarFixed && this.endVarFixed) {
                Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "_" + this.hashCode());
                VarReplacer replacer = new VarReplacer(this.endVar, replacement, 0L, false);
                pathExprClone.visit(replacer);
            }
            this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            ++this.currentLength;
        } else {
            this.currentVp = this.valueQueue.poll();
            if (this.currentVp != null) {
                TupleExpr pathExprClone = this.pathExpression.clone();
                if (this.startVarFixed && this.endVarFixed) {
                    Var startReplacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "_" + this.hashCode());
                    Var endReplacement = this.createAnonVar("END_intermediate_join_" + this.hashCode());
                    startReplacement.setAnonymous(false);
                    endReplacement.setAnonymous(false);
                    Value v = this.currentVp.getEndValue();
                    startReplacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(this.startVar, startReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                    replacer = new VarReplacer(this.endVar, endReplacement, 0L, false);
                    pathExprClone.visit(replacer);
                } else {
                    Value v;
                    Var toBeReplaced;
                    if (!this.endVarFixed) {
                        toBeReplaced = this.startVar;
                        v = this.currentVp.getEndValue();
                    } else {
                        toBeReplaced = this.endVar;
                        v = this.currentVp.getStartValue();
                    }
                    Var replacement = this.createAnonVar(JOINVAR_PREFIX + this.currentLength + "-" + this.hashCode());
                    replacement.setValue(v);
                    VarReplacer replacer = new VarReplacer(toBeReplaced, replacement, 0L, false);
                    pathExprClone.visit(replacer);
                }
                this.currentIter = this.strategy.evaluate(pathExprClone, this.bindings);
            } else {
                this.currentIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
            }
            ++this.currentLength;
        }
    }

    protected boolean isUnbound(Var var, BindingSet bindings) {
        if (var == null) {
            return false;
        }
        return bindings.hasBinding(var.getName()) && bindings.getValue(var.getName()) == null;
    }

    public Var createAnonVar(String varName) {
        Var var = new Var(varName);
        var.setAnonymous(true);
        return var;
    }

    class VarReplacer
    extends AbstractQueryModelVisitor<QueryEvaluationException> {
        private final Var toBeReplaced;
        private final Var replacement;
        private final long index;
        private final boolean replaceAnons;

        public VarReplacer(Var toBeReplaced, Var replacement, long index, boolean replaceAnons) {
            this.toBeReplaced = toBeReplaced;
            this.replacement = replacement;
            this.index = index;
            this.replaceAnons = replaceAnons;
        }

        @Override
        public void meet(Var var) {
            if (this.toBeReplaced.equals(var) || this.toBeReplaced.isAnonymous() && var.isAnonymous() && this.toBeReplaced.hasValue() && this.toBeReplaced.getValue().equals(var.getValue())) {
                QueryModelNode parent = var.getParentNode();
                Var replacement = this.replacement.clone();
                parent.replaceChildNode(var, replacement);
                assert (replacement.getParentNode() == parent);
            } else if (this.replaceAnons && var.isAnonymous() && !var.hasValue()) {
                Var replacementVar = PathIteration.this.createAnonVar("anon-replace-" + var.getName() + this.index);
                QueryModelNode parent = var.getParentNode();
                parent.replaceChildNode(var, replacementVar);
                assert (replacementVar.getParentNode() == parent);
            }
        }
    }

    protected static class ValuePair {
        private final Value startValue;
        private final Value endValue;

        public ValuePair(Value startValue, Value endValue) {
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public Value getStartValue() {
            return this.startValue;
        }

        public Value getEndValue() {
            return this.endValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
            result = 31 * result + (this.startValue == null ? 0 : this.startValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ValuePair)) {
                return false;
            }
            ValuePair other = (ValuePair)obj;
            if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
                return false;
            }
            return !(this.startValue == null ? other.startValue != null : !this.startValue.equals(other.startValue));
        }
    }
}

