/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.util.Objects;
import org.apache.zookeeper.common.FileKeyStoreLoader;
import org.apache.zookeeper.common.JKSFileLoader;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.PEMFileLoader;

public class FileKeyStoreLoaderBuilderProvider {
    static FileKeyStoreLoader.Builder<? extends FileKeyStoreLoader> getBuilderForKeyStoreFileType(KeyStoreFileType type) {
        switch (Objects.requireNonNull(type)) {
            case JKS: {
                return new JKSFileLoader.Builder();
            }
            case PEM: {
                return new PEMFileLoader.Builder();
            }
        }
        throw new AssertionError((Object)("Unexpected StoreFileType: " + type.name()));
    }
}

