/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.config;

import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.shacl.config.ShaclSailSchema;

public class ShaclSailConfig
extends AbstractDelegatingSailImplConfig {
    public static final boolean PARALLEL_VALIDATION_DEFAULT = true;
    public static final boolean UNDEFINED_TARGET_VALIDATES_ALL_SUBJECTS_DEFAULT = false;
    public static final boolean LOG_VALIDATION_PLANS_DEFAULT = false;
    public static final boolean LOG_VALIDATION_VIOLATIONS_DEFAULT = false;
    public static final boolean IGNORE_NO_SHAPES_LOADED_EXCEPTION_DEFAULT = false;
    public static final boolean VALIDATION_ENABLED_DEFAULT = true;
    public static final boolean CACHE_SELECT_NODES_DEFAULT = true;
    public static final boolean GLOBAL_LOG_VALIDATION_EXECUTION_DEFAULT = false;
    public static final boolean RDFS_SUB_CLASS_REASONING_DEFAULT = true;
    public static final boolean PERFORMANCE_LOGGING_DEFAULT = false;
    public static final boolean SERIALIZABLE_VALIDATION_DEFAULT = true;
    public static final boolean ECLIPSE_RDF4J_SHACL_EXTENSIONS_DEFAULT = false;
    public static final boolean DASH_DATA_SHAPES_DEFAULT = false;
    public static final long VALIDATION_RESULTS_LIMIT_TOTAL_DEFAULT = -1L;
    public static final long VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT_DEFAULT = -1L;
    private boolean parallelValidation = true;
    private boolean undefinedTargetValidatesAllSubjects = false;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean ignoreNoShapesLoadedException = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean globalLogValidationExecution = false;
    private boolean rdfsSubClassReasoning = true;
    private boolean performanceLogging = false;
    private boolean serializableValidation = true;
    private boolean eclipseRdf4jShaclExtensions = false;
    private boolean dashDataShapes = false;
    private long validationResultsLimitTotal = -1L;
    private long validationResultsLimitPerConstraint = -1L;

    public ShaclSailConfig() {
        super("rdf4j:ShaclSail");
    }

    public ShaclSailConfig(SailImplConfig delegate) {
        super("rdf4j:ShaclSail", delegate);
    }

    @Deprecated
    public boolean isUndefinedTargetValidatesAllSubjects() {
        return this.undefinedTargetValidatesAllSubjects;
    }

    @Deprecated
    public void setUndefinedTargetValidatesAllSubjects(boolean undefinedTargetValidatesAllSubjects) {
        this.undefinedTargetValidatesAllSubjects = undefinedTargetValidatesAllSubjects;
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public boolean isGlobalLogValidationExecution() {
        return this.globalLogValidationExecution;
    }

    public void setGlobalLogValidationExecution(boolean globalLogValidationExecution) {
        this.globalLogValidationExecution = globalLogValidationExecution;
    }

    @Deprecated
    public boolean isIgnoreNoShapesLoadedException() {
        return this.ignoreNoShapesLoadedException;
    }

    @Deprecated
    public void setIgnoreNoShapesLoadedException(boolean ignoreNoShapesLoadedException) {
        this.ignoreNoShapesLoadedException = ignoreNoShapesLoadedException;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    public boolean isPerformanceLogging() {
        return this.performanceLogging;
    }

    public void setPerformanceLogging(boolean performanceLogging) {
        this.performanceLogging = performanceLogging;
    }

    public boolean isSerializableValidation() {
        return this.serializableValidation;
    }

    public void setSerializableValidation(boolean serializableValidation) {
        this.serializableValidation = serializableValidation;
    }

    @Experimental
    public boolean isEclipseRdf4jShaclExtensions() {
        return this.eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public void setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
        this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
    }

    @Experimental
    public boolean isDashDataShapes() {
        return this.dashDataShapes;
    }

    @Experimental
    public void setDashDataShapes(boolean dashDataShapes) {
        this.dashDataShapes = dashDataShapes;
    }

    public long getValidationResultsLimitTotal() {
        return this.validationResultsLimitTotal;
    }

    public long getValidationResultsLimitPerConstraint() {
        return this.validationResultsLimitPerConstraint;
    }

    public void setValidationResultsLimitTotal(long validationResultsLimitTotal) {
        this.validationResultsLimitTotal = validationResultsLimitTotal;
    }

    public void setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
        this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
    }

    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace("sail-shacl", "http://rdf4j.org/config/sail/shacl#");
        m.add(implNode, ShaclSailSchema.PARALLEL_VALIDATION, (Value)BooleanLiteral.valueOf((boolean)this.isParallelValidation()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.UNDEFINED_TARGET_VALIDATES_ALL_SUBJECTS, (Value)BooleanLiteral.valueOf((boolean)this.isUndefinedTargetValidatesAllSubjects()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.LOG_VALIDATION_PLANS, (Value)BooleanLiteral.valueOf((boolean)this.isLogValidationPlans()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.LOG_VALIDATION_VIOLATIONS, (Value)BooleanLiteral.valueOf((boolean)this.isLogValidationViolations()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.IGNORE_NO_SHAPES_LOADED_EXCEPTION, (Value)BooleanLiteral.valueOf((boolean)this.isIgnoreNoShapesLoadedException()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.VALIDATION_ENABLED, (Value)BooleanLiteral.valueOf((boolean)this.isValidationEnabled()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.CACHE_SELECT_NODES, (Value)BooleanLiteral.valueOf((boolean)this.isCacheSelectNodes()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.GLOBAL_LOG_VALIDATION_EXECUTION, (Value)BooleanLiteral.valueOf((boolean)this.isGlobalLogValidationExecution()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.RDFS_SUB_CLASS_REASONING, (Value)BooleanLiteral.valueOf((boolean)this.isRdfsSubClassReasoning()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.PERFORMANCE_LOGGING, (Value)BooleanLiteral.valueOf((boolean)this.isPerformanceLogging()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.SERIALIZABLE_VALIDATION, (Value)BooleanLiteral.valueOf((boolean)this.isSerializableValidation()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.ECLIPSE_RDF4J_SHACL_EXTENSIONS, (Value)BooleanLiteral.valueOf((boolean)this.isEclipseRdf4jShaclExtensions()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.DASH_DATA_SHAPES, (Value)BooleanLiteral.valueOf((boolean)this.isDashDataShapes()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_TOTAL, (Value)Values.literal((long)this.getValidationResultsLimitTotal()), new Resource[0]);
        m.add(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT, (Value)Values.literal((long)this.getValidationResultsLimitPerConstraint()), new Resource[0]);
        return implNode;
    }

    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.PARALLEL_VALIDATION, null, new Resource[0])).ifPresent(l -> this.setParallelValidation(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.UNDEFINED_TARGET_VALIDATES_ALL_SUBJECTS, null, new Resource[0])).ifPresent(l -> this.setUndefinedTargetValidatesAllSubjects(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.LOG_VALIDATION_PLANS, null, new Resource[0])).ifPresent(l -> this.setLogValidationPlans(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.LOG_VALIDATION_VIOLATIONS, null, new Resource[0])).ifPresent(l -> this.setLogValidationViolations(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.IGNORE_NO_SHAPES_LOADED_EXCEPTION, null, new Resource[0])).ifPresent(l -> this.setIgnoreNoShapesLoadedException(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.VALIDATION_ENABLED, null, new Resource[0])).ifPresent(l -> this.setValidationEnabled(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.CACHE_SELECT_NODES, null, new Resource[0])).ifPresent(l -> this.setCacheSelectNodes(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.GLOBAL_LOG_VALIDATION_EXECUTION, null, new Resource[0])).ifPresent(l -> this.setGlobalLogValidationExecution(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.RDFS_SUB_CLASS_REASONING, null, new Resource[0])).ifPresent(l -> this.setRdfsSubClassReasoning(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.PERFORMANCE_LOGGING, null, new Resource[0])).ifPresent(l -> this.setPerformanceLogging(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.SERIALIZABLE_VALIDATION, null, new Resource[0])).ifPresent(l -> this.setSerializableValidation(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.ECLIPSE_RDF4J_SHACL_EXTENSIONS, null, new Resource[0])).ifPresent(l -> this.setEclipseRdf4jShaclExtensions(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.DASH_DATA_SHAPES, null, new Resource[0])).ifPresent(l -> this.setDashDataShapes(l.booleanValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_TOTAL, null, new Resource[0])).ifPresent(l -> this.setValidationResultsLimitTotal(l.longValue()));
            Models.objectLiteral((Iterable)m.getStatements(implNode, ShaclSailSchema.VALIDATION_RESULTS_LIMIT_PER_CONSTRAINT, null, new Resource[0])).ifPresent(l -> this.setValidationResultsLimitPerConstraint(l.longValue()));
        }
        catch (IllegalArgumentException e) {
            throw new SailConfigException("error parsing Sail configuration", (Throwable)e);
        }
    }
}

