/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.OrPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.planNodes.AggregateIteratorTypeOverride;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndPropertyShape
extends PathPropertyShape {
    private final List<List<PathPropertyShape>> and;
    private static final Logger logger = LoggerFactory.getLogger(AndPropertyShape.class);

    AndPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource and, ShaclSail shaclSail) {
        super(id, connection, nodeShape, deactivated, parent, path);
        this.and = this.getPropertyShapes(connection, nodeShape, shaclSail, and);
        if (!this.and.stream().flatMap(Collection::stream).findAny().isPresent()) {
            logger.warn("sh:and contained no supported shapes: " + id);
            this.deactivated = true;
        }
    }

    private List<List<PathPropertyShape>> getPropertyShapes(SailRepositoryConnection connection, NodeShape nodeShape, ShaclSail shaclSail, Resource and) {
        return AndPropertyShape.toList(connection, and).stream().map(v -> PropertyShape.Factory.getPropertyShapesInner(connection, nodeShape, (Resource)v, this, shaclSail).stream().filter(s -> !s.deactivated).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public AndPropertyShape(Resource id, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Path path, List<List<PathPropertyShape>> and) {
        super(id, nodeShape, deactivated, parent, path);
        this.and = and;
        if (!this.and.stream().flatMap(Collection::stream).findAny().isPresent()) {
            logger.warn("sh:and contained no supported shapes: " + id);
            this.deactivated = true;
        }
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        if (negateThisPlan) {
            OrPropertyShape orPropertyShape = new OrPropertyShape(this.getId(), this.nodeShape, this.deactivated, this, null, this.and);
            EnrichWithShape plan = (EnrichWithShape)orPropertyShape.getPlan(connectionsGroup, false, overrideTargetNode, false, true);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(plan, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(plan.getParent(), this);
        }
        if (this.and.stream().mapToLong(List::size).sum() == 1L) {
            PlanNode plan = this.and.get(0).get(0).getPlan(connectionsGroup, false, overrideTargetNode, negateSubPlans, false);
            if (printPlans) {
                String planAsGraphvizDot = this.getPlanAsGraphvizDot(plan, connectionsGroup);
                logger.info(planAsGraphvizDot);
            }
            return new EnrichWithShape(plan, this);
        }
        List<PlanNode> plans = this.and.stream().flatMap(Collection::stream).map(shape -> shape.getPlan(connectionsGroup, false, overrideTargetNode, negateSubPlans, false)).collect(Collectors.toList());
        PlanNode unionPlan = AndPropertyShape.unionAll(plans);
        List iteratorDataTypes = plans.stream().map(PlanNode::getIteratorDataType).distinct().collect(Collectors.toList());
        IteratorData iteratorData = (IteratorData)((Object)iteratorDataTypes.get(0));
        if (iteratorDataTypes.size() > 1) {
            iteratorData = IteratorData.aggregated;
        }
        if (iteratorData == IteratorData.tripleBased && this.childrenHasOwnPath()) {
            iteratorData = IteratorData.aggregated;
        }
        if (iteratorData == IteratorData.aggregated) {
            unionPlan = new AggregateIteratorTypeOverride(new Unique(new TrimTuple(unionPlan, 0, 1)));
        }
        if (printPlans) {
            String planAsGraphvizDot = this.getPlanAsGraphvizDot(unionPlan, connectionsGroup);
            logger.info(planAsGraphvizDot);
        }
        return new EnrichWithShape(unionPlan, this);
    }

    private static PlanNode unionAll(List<PlanNode> planNodes) {
        return new Unique(new UnionNode(planNodes.toArray(new PlanNode[0])));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements, Stats stats) {
        if (this.deactivated) {
            return false;
        }
        return super.requiresEvaluation(addedStatements, removedStatements, stats) || this.and.stream().flatMap(Collection::stream).map(p -> p.requiresEvaluation(addedStatements, removedStatements, stats)).reduce((a, b) -> a != false || b != false).orElse(false) != false;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.AndConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndPropertyShape that = (AndPropertyShape)o;
        return this.and.equals(that.and);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.and);
    }

    public String toString() {
        return "AndPropertyShape{and=" + AndPropertyShape.toString(this.and) + ", id=" + this.id + '}';
    }

    public boolean childrenHasOwnPath() {
        return this.and.stream().flatMap(a -> a.stream().map(PathPropertyShape::hasOwnPath)).anyMatch(a -> a);
    }

    @Override
    public boolean childrenHasOwnPathRecursive() {
        return this.and.stream().flatMap(a -> a.stream().map(PathPropertyShape::childrenHasOwnPathRecursive)).anyMatch(a -> a);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        Optional<PlanNode> reduce = this.and.stream().flatMap(Collection::stream).map(a -> a.getAllTargetsPlan(connectionsGroup, negated)).reduce((a, b) -> new UnionNode((PlanNode)a, (PlanNode)b));
        return new Unique(reduce.get());
    }

    @Override
    public String buildSparqlValidNodes(String targetVar) {
        if (this.hasOwnPath()) {
            String objectVariable = this.randomVariable();
            String pathQuery1 = this.getPath().getQuery(targetVar, objectVariable, null);
            String collect = this.and.stream().map(l -> l.stream().map(p -> p.buildSparqlValidNodes(objectVariable)).reduce((a, b) -> a + " && " + b)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(" ) && ( ", "( ", " )"));
            String query = pathQuery1 + "\n FILTER (! EXISTS {\n" + pathQuery1.replaceAll("(?m)^", "\t") + "\n\tFILTER(!(" + collect + "))\n})";
            String pathQuery2 = this.getPath().getQuery(targetVar, this.randomVariable(), null);
            query = "{\n#VALUES_INJECTION_POINT#\n " + query.replaceAll("(?m)^", "\t") + " \n} UNION {\n\t" + "#VALUES_INJECTION_POINT#" + "\n\t" + targetVar + " " + this.randomVariable() + " " + this.randomVariable() + ".\n\tFILTER(NOT EXISTS {\n " + pathQuery2.replaceAll("(?m)^", "\t") + " \n})\n}";
            return query;
        }
        if (!this.childrenHasOwnPathRecursive()) {
            return this.and.stream().map(l -> l.stream().map(p -> p.buildSparqlValidNodes(targetVar)).reduce((a, b) -> a + " && " + b)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining(" ) && ( ", "( ", " )"));
        }
        return this.and.stream().map(propertyShapes -> propertyShapes.stream().map(propertyShape -> propertyShape.buildSparqlValidNodes(targetVar)).reduce((a, b) -> a + "\n" + b)).filter(Optional::isPresent).map(Optional::get).reduce((a, b) -> a + "\n" + b).orElse("");
    }

    @Override
    public Stream<StatementPattern> getStatementPatterns() {
        Stream<Object> allSubjectsObjects;
        if (this.hasOwnPath()) {
            StatementPattern subject = new StatementPattern(new Var("?this"), new Var(UUID.randomUUID().toString()), new Var(UUID.randomUUID().toString()));
            StatementPattern object = new StatementPattern(new Var(UUID.randomUUID().toString()), new Var(UUID.randomUUID().toString()), new Var("?this"));
            allSubjectsObjects = Stream.of(subject, object);
        } else {
            allSubjectsObjects = Stream.empty();
        }
        Stream statementPatternStream = this.and.stream().flatMap(Collection::stream).flatMap(PropertyShape::getStatementPatterns);
        return Stream.concat(statementPatternStream, allSubjectsObjects);
    }
}

