/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantSuperCallCleanUp
extends AbstractMultiFix
implements ICleanUpFix {
    public RedundantSuperCallCleanUp() {
        this(Collections.emptyMap());
    }

    public RedundantSuperCallCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.no_super");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.no_super")) {
            return new String[]{MultiFixMessages.RedundantSuperCallCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("MyClass() {\n");
        if (this.isEnabled("cleanup.no_super")) {
            bld.append("}\n\n");
        } else {
            bld.append("  super();\n");
            bld.append("}\n");
        }
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.no_super")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(SuperConstructorInvocation node) {
                if (node.arguments().isEmpty()) {
                    rewriteOperations.add(new RedundantSuperCallOperation(node));
                    return false;
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.RedundantSuperCallCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RedundantSuperCallOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final SuperConstructorInvocation node;

        public RedundantSuperCallOperation(SuperConstructorInvocation node) {
            this.node = node;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantSuperCallCleanup_description, cuRewrite);
            ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.node, group);
        }
    }
}

