/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ReturnExpressionFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class ReturnExpressionCleanUpCore
extends AbstractCleanUp {
    public ReturnExpressionCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public ReturnExpressionCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.return_expression");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.return_expression")) {
            return null;
        }
        return ReturnExpressionFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.return_expression")) {
            result.add(MultiFixMessages.ReturnExpressionCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("public int getNumber() {\n");
        if (this.isEnabled("cleanup.return_expression")) {
            bld.append("    return 0;\n");
        } else {
            bld.append("    int i = 0;\n");
            bld.append("    return i;\n");
        }
        bld.append("}\n");
        if (this.isEnabled("cleanup.return_expression")) {
            bld.append("\n");
        }
        return bld.toString();
    }
}

