/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.EclDouble;
import org.eclipse.rcptt.ecl.core.EclFloat;
import org.eclipse.rcptt.ecl.core.EclInteger;
import org.eclipse.rcptt.ecl.core.EclLong;
import org.eclipse.rcptt.ecl.operations.Abs;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.operations.internal.commands.BinaryOpService;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class AbsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof Abs)) {
            return Status.CANCEL_STATUS;
        }
        BoxedValue arg = BinaryOpService.convertToNumber(((Abs)command).getArg());
        arg = BoxedValues.toType((BoxedValue)arg, (EClass)BinaryOpService.max(arg.eClass()));
        context.getOutput().write((Object)AbsService.calcAbs(arg));
        return Status.OK_STATUS;
    }

    private static BoxedValue calcAbs(BoxedValue value) throws CoreException {
        if (value instanceof EclInteger) {
            return BoxedValues.box((int)Math.abs(((EclInteger)value).getValue()));
        }
        if (value instanceof EclLong) {
            return BoxedValues.box((long)Math.abs(((EclLong)value).getValue()));
        }
        if (value instanceof EclDouble) {
            return BoxedValues.box((double)Math.abs(((EclDouble)value).getValue()));
        }
        if (value instanceof EclFloat) {
            return BoxedValues.box((float)Math.abs(((EclFloat)value).getValue()));
        }
        throw new CoreException(OperationsPlugin.createErr("Unexpected arg type: %s", value.eClass().getName()));
    }
}

