/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model.cache;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public final class ValueLock {
    private final Set<Object> lockedKeys = new HashSet<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(Object key, int timeout_ms) throws InterruptedException, TimeoutException {
        Preconditions.checkArgument((timeout_ms >= 0 ? 1 : 0) != 0);
        long stop = System.currentTimeMillis() + (long)timeout_ms;
        boolean timeout = false;
        Set<Object> set = this.lockedKeys;
        synchronized (set) {
            while (!this.lockedKeys.add(key)) {
                long timeLeft = stop - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    timeout = true;
                    break;
                }
                this.lockedKeys.wait(timeLeft);
            }
        }
        if (timeout) {
            throw new TimeoutException("Timeout while locking " + key.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Object key) {
        Set<Object> set = this.lockedKeys;
        synchronized (set) {
            this.lockedKeys.remove(key);
            this.lockedKeys.notifyAll();
        }
    }

    public <V> V exclusively(Object key, int timeout_ms, Supplier<V> supplier) throws InterruptedException, TimeoutException {
        this.lock(key, timeout_ms);
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            this.unlock(key);
        }
    }
}

