/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.util.FileSystemResolver;

public class PrefixScheme
implements FileSystemResolver.Scheme {
    public static final String AUT = "aut://";
    public static final String WORKSPACE = "workspace://";
    public static final String FILE = "file://";
    public static final String HOME = "home://";
    private final String prefix;
    private final String root;

    public PrefixScheme(String prefix, String root) {
        this.prefix = prefix;
        this.root = root != null ? FileSystemResolver.normalizeSlashes(root) : "";
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String resolve(String path) {
        String unprefixed = FileSystemResolver.unprefix(this.prefix, path);
        if (unprefixed == null) {
            return null;
        }
        return this.root + FileSystemResolver.normalizeSlashes(unprefixed);
    }

    @Override
    public String make(String path) {
        path = FileSystemResolver.normalizeSlashes(path);
        String workingRoot = this.root;
        String workingPath = path;
        if (Platform.getOS().equals("win32")) {
            workingPath = path.toLowerCase();
            workingRoot = this.root.toLowerCase();
        }
        if (!workingPath.startsWith(workingRoot)) {
            return null;
        }
        path = path.substring(this.root.length());
        return this.prefix + path;
    }
}

