/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.rap.ui;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.launching.rap.IBrowserLaunchDelegate;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class BrowserLaucherDelegate
implements IBrowserLaunchDelegate {
    public void launch(URL url, RAPLaunchConfig config) throws CoreException {
        BrowserLaucherDelegate.openUrl(this.getBrowser(config), url);
    }

    private IWebBrowser getBrowser(final RAPLaunchConfig config) throws CoreException {
        final IWebBrowser[] result = new IWebBrowser[1];
        final CoreException[] exception = new CoreException[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchBrowserSupport support = workbench.getBrowserSupport();
                    int style = 14;
                    style = RAPLaunchConfig.BrowserMode.EXTERNAL.equals(config.getBrowserMode()) ? (style |= 0x80) : (style |= 0x20);
                    String id = config.getName() + String.valueOf(config.getBrowserMode());
                    String name = config.getName();
                    String toolTip = config.getName();
                    result[0] = support.createBrowser(style, id, name, toolTip);
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    private static void openUrl(final IWebBrowser browser, final URL url) throws PartInitException {
        final PartInitException[] exception = new PartInitException[1];
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    browser.openURL(url);
                }
                catch (PartInitException e) {
                    String text = "Failed to open URL ''{0}'' in browser.";
                    String msg = MessageFormat.format(text, url);
                    String pluginId = "org.eclipse.rcptt.launching.ext.ui";
                    Status status = new Status(4, pluginId, msg, (Throwable)e);
                    exception[0] = new PartInitException((IStatus)status);
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }
}

