/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.merge.CompareEditorInputViewerAction;
import org.eclipse.egit.ui.internal.merge.MergeDiffNode;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ToggleCurrentChangesAction
extends CompareEditorInputViewerAction {
    public static final String COMMAND_ID = "org.eclipse.egit.ui.internal.merge.ToggleCurrentChangesCommand";

    public ToggleCurrentChangesAction(String title, CompareEditorInput comparison) {
        super(title, 2, comparison);
        CompareConfiguration config = comparison.getCompareConfiguration();
        this.setChecked(config.isChangeIgnored(this.currentSide(config)));
        if (config.isMirrored()) {
            this.setImageDescriptor(UIIcons.IGNORE_RIGHT_CHANGES);
        } else {
            this.setImageDescriptor(UIIcons.IGNORE_LEFT_CHANGES);
        }
        this.addEventListeners(config);
    }

    private void addEventListeners(CompareConfiguration config) {
        config.addPropertyChangeListener(event -> {
            if (ICompareUIConstants.PROP_IGNORE_ANCESTOR.equals(event.getProperty())) {
                boolean threeWay = this.isThreeWay(config);
                if (threeWay) {
                    super.setEnabled(true);
                    if (this.isEnabled()) {
                        this.run();
                    }
                } else {
                    super.setEnabled(false);
                    this.forceOff();
                }
            }
        });
    }

    private boolean isThreeWay(CompareConfiguration config) {
        Object property = config.getProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR);
        if (property instanceof Boolean) {
            return (Boolean)property == false;
        }
        if (property == null) {
            return true;
        }
        return !Boolean.parseBoolean(property.toString());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled && this.isThreeWay(this.getInput().getCompareConfiguration()));
    }

    public void run() {
        ContentMergeViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Object input = viewer.getInput();
        if (input instanceof MergeDiffNode) {
            boolean ignoreLeft = this.isChecked();
            CompareConfiguration config = this.getInput().getCompareConfiguration();
            int side = this.currentSide(config);
            int otherSide = side == 3 ? 2 : 3;
            boolean anyDifference = ignoreLeft ^ config.isChangeIgnored(side);
            anyDifference |= ignoreLeft ^ config.isChangeIgnored(4);
            if (anyDifference |= config.isChangeIgnored(otherSide)) {
                config.setChangeIgnored(side, ignoreLeft);
                config.setChangeIgnored(4, ignoreLeft);
                config.setChangeIgnored(otherSide, false);
                ((MergeDiffNode)((Object)input)).fireChange();
            }
        }
    }

    private void forceOff() {
        ContentMergeViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        Object input = viewer.getInput();
        if (input instanceof MergeDiffNode) {
            CompareConfiguration config = this.getInput().getCompareConfiguration();
            boolean anyIgnored = config.isChangeIgnored(3);
            anyIgnored |= config.isChangeIgnored(4);
            if (anyIgnored |= config.isChangeIgnored(2)) {
                config.setChangeIgnored(3, false);
                config.setChangeIgnored(4, false);
                config.setChangeIgnored(2, false);
                ((MergeDiffNode)((Object)input)).fireChange();
            }
        }
    }

    private int currentSide(CompareConfiguration config) {
        if (config.isMirrored()) {
            return 2;
        }
        return 3;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("MIRRORED".equals(event.getProperty())) {
            if (this.getInput().getCompareConfiguration().isMirrored()) {
                this.setImageDescriptor(UIIcons.IGNORE_RIGHT_CHANGES);
            } else {
                this.setImageDescriptor(UIIcons.IGNORE_LEFT_CHANGES);
            }
            if (this.isEnabled()) {
                this.run();
            }
        }
    }
}

