/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Operation;

public class BecomeWorkingCopyOperation
extends Q7Operation {
    private boolean indexing = false;

    public BecomeWorkingCopyOperation(Q7NamedElement workingCopy, boolean indexing) {
        super(new IQ7Element[]{workingCopy});
        this.indexing = indexing;
    }

    @Override
    protected void executeOperation() throws ModelException {
        Q7NamedElement workingCopy = this.getWorkingCopy();
        workingCopy.workingCopyMode = true;
        workingCopy.setIndexing(this.indexing);
        ModelManager.PerWorkingCopyInfo copyInfo = ModelManager.getModelManager().getPerWorkingCopyInfo(workingCopy, true, true);
        try {
            copyInfo.populate(this.progressMonitor);
            this.resultElements = new IQ7Element[]{workingCopy};
        }
        catch (ModelException e) {
            throw e;
        }
        finally {
            workingCopy.discardWorkingCopy();
        }
    }

    protected Q7NamedElement getWorkingCopy() {
        return (Q7NamedElement)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

