/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;

public class BuildDependencyCollector {
    private final Collection<BundleDescription> fDependencies = new HashSet<BundleDescription>();
    private final Queue<BundleDescription> fQueue = new ArrayDeque<BundleDescription>();

    private BuildDependencyCollector(Collection<BundleDescription> roots) {
        this.fQueue.addAll(roots);
        this.fDependencies.addAll(roots);
    }

    public static Collection<BundleDescription> collectBuildRelevantDependencies(Collection<BundleDescription> roots) {
        BuildDependencyCollector collector = new BuildDependencyCollector(roots);
        collector.collect();
        return collector.fDependencies;
    }

    private void collect() {
        while (!this.fQueue.isEmpty()) {
            BundleDescription bundleDescription = this.fQueue.remove();
            this.collectRequiredBundles(bundleDescription);
            this.collectImportedPackages(bundleDescription);
            this.collectFragmentHost(bundleDescription);
        }
    }

    private void collectRequiredBundles(BundleDescription bundle) {
        BundleSpecification[] bundleSpecificationArray = bundle.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification required = bundleSpecificationArray[n2];
            BundleDescription supplier = (BundleDescription)required.getSupplier();
            this.enqueueDependency(supplier);
            ++n2;
        }
    }

    private void collectImportedPackages(BundleDescription bundle) {
        ImportPackageSpecification[] importPackageSpecificationArray = bundle.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackage = importPackageSpecificationArray[n2];
            BaseDescription supplier = importPackage.getSupplier();
            if (supplier instanceof ExportPackageDescription) {
                this.enqueueDependency(((ExportPackageDescription)supplier).getExporter());
            }
            ++n2;
        }
    }

    private void collectFragmentHost(BundleDescription bundle) {
        BaseDescription supplier;
        HostSpecification host = bundle.getHost();
        if (host != null && (supplier = host.getSupplier()) instanceof BundleDescription) {
            this.enqueueDependency((BundleDescription)supplier);
        }
    }

    private void enqueueDependency(BundleDescription dependency) {
        if (dependency != null && this.fDependencies.add(dependency)) {
            this.fQueue.add(dependency);
        }
    }
}

