/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.views.features.support.FeatureIndex;
import org.eclipse.pde.internal.ui.views.features.support.FeatureSupport;
import org.eclipse.pde.internal.ui.views.features.support.PluginSupport;
import org.eclipse.pde.internal.ui.views.features.support.ProductSupport;

public class FeaturesViewInput {
    private final FeatureSupport fFeatureSupport = new FeatureSupport();
    private final ProductSupport fProductSupport = new ProductSupport();
    private final PluginSupport fPluginSupport = new PluginSupport();
    private final FeatureIndex fIndex = new FeatureIndex(this.fFeatureSupport.getManager(), this.fProductSupport.getManager());
    private boolean fIncludeProducts;
    private boolean fIncludePlugins;

    public IModel[] getModels() {
        IFeatureModel[] featureModels = this.getFeatures();
        IProductModel[] productModels = this.getProducts();
        ArrayList<Object> all = new ArrayList<Object>(productModels.length + featureModels.length);
        all.addAll(Arrays.asList(productModels));
        all.addAll(Arrays.asList(featureModels));
        return all.toArray(new IModel[all.size()]);
    }

    private IFeatureModel[] getFeatures() {
        this.ensureInitialized();
        return this.fFeatureSupport.getManager().getModels();
    }

    private IProductModel[] getProducts() {
        this.ensureInitialized();
        return this.fProductSupport.getManager().getModels();
    }

    public Collection<IFeatureModel> getIncludingFeatures(String childId) {
        this.ensureInitialized();
        return this.fIndex.getIncludingFeatures(childId);
    }

    public Collection<IProductModel> getIncludingProducts(String featureId) {
        this.ensureInitialized();
        return this.fIndex.getIncludingProducts(featureId);
    }

    public boolean isInitialized() {
        return this.fFeatureSupport.getManager().isInitialized() && this.fProductSupport.getManager().isInitialized() && this.fIndex.isInitialized();
    }

    private void ensureInitialized() {
        this.fIndex.ensureInitialized();
    }

    public boolean isIncludeProducts() {
        return this.fIncludeProducts;
    }

    public void setIncludeProducts(boolean includeProducts) {
        this.fIncludeProducts = includeProducts;
    }

    public boolean isIncludePlugins() {
        return this.fIncludePlugins;
    }

    public void setIncludePlugins(boolean includePlugins) {
        this.fIncludePlugins = includePlugins;
    }

    public FeatureSupport getFeatureSupport() {
        return this.fFeatureSupport;
    }

    public ProductSupport getProductSupport() {
        return this.fProductSupport;
    }

    public PluginSupport getPluginSupport() {
        return this.fPluginSupport;
    }

    public void dispose() {
        this.fIndex.dispose();
        this.fProductSupport.dispose();
    }
}

