/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons.listcelleditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.rcptt.ui.commons.listcelleditor.ChangeListDialog;
import org.eclipse.rcptt.ui.commons.listcelleditor.DefaultLabelProvider;
import org.eclipse.rcptt.ui.commons.listcelleditor.StringWrapper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class StringListCellEditor
extends ExtendedDialogCellEditor {
    private String name;
    private List<String> values;
    private boolean valueChanged;

    public StringListCellEditor(Composite composite, List<String> values, String name) {
        super(composite, (ILabelProvider)new DefaultLabelProvider());
        this.values = values;
        this.name = name;
        this.valueChanged = false;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Shell shell = cellEditorWindow.getShell();
        ChangeListDialog dialog = new ChangeListDialog(shell, this.toWrapper(this.values), this.name);
        dialog.open();
        this.valueChanged = true;
        return this.toString(dialog.getResult());
    }

    protected Object doGetValue() {
        if (this.valueChanged) {
            return super.doGetValue();
        }
        return this.values;
    }

    private List<String> toString(List<StringWrapper> list) {
        BasicEList result = new BasicEList();
        if (list != null) {
            for (StringWrapper wrapper : list) {
                result.add(wrapper.getString());
            }
        }
        return result;
    }

    private List<StringWrapper> toWrapper(List<String> list) {
        ArrayList<StringWrapper> result = new ArrayList<StringWrapper>();
        if (list != null) {
            for (String elem : list) {
                StringWrapper wrapper = new StringWrapper();
                wrapper.setString(elem);
                result.add(wrapper);
            }
        }
        return result;
    }
}

