/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.streams;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.rcptt.sherlock.core.SherlockCore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportFormat;

public class SherlockReportIterator {
    private ZipInputStream zin;
    ZipEntry currentEntry;
    private File reportFile;

    public SherlockReportIterator(File file) {
        this.reportFile = file;
        this.reset();
    }

    public void reset() {
        if (this.zin != null) {
            try {
                this.zin.close();
            }
            catch (IOException e) {
                SherlockCore.log(e);
            }
        }
        try {
            this.zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.reportFile)));
            this.currentEntry = this.zin.getNextEntry();
        }
        catch (IOException e) {
            SherlockCore.log(e);
        }
    }

    public boolean hasNext() {
        return this.currentEntry != null;
    }

    public Report next() {
        try {
            if (this.currentEntry.getName().equals("ResourceContents")) {
                Report report = SherlockReportFormat.loadReport(this.zin, false, false);
                this.currentEntry = null;
                return report;
            }
            Report report = SherlockReportFormat.loadReport(this.zin, false, true);
            this.currentEntry = this.zin.getNextEntry();
            return report;
        }
        catch (Throwable e) {
            SherlockCore.log(e);
            this.currentEntry = null;
            return null;
        }
    }

    public void close() {
        this.currentEntry = null;
        try {
            if (this.zin != null) {
                this.zin.close();
            }
        }
        catch (Throwable e) {
            SherlockCore.log(e);
        }
    }

    public File getReportFile() {
        return this.reportFile;
    }
}

