/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.w3c.dom.Node;

public class FeaturePlugin
extends FeatureData
implements IFeaturePlugin {
    private static final long serialVersionUID = 1L;
    private String fVersion;

    @Override
    protected void reset() {
        super.reset();
        this.fVersion = null;
    }

    @Override
    public boolean isFragment() {
        return this.getPluginBase() instanceof IFragment;
    }

    public IPluginBase getPluginBase() {
        if (this.id == null) {
            return null;
        }
        String version = this.getVersion();
        IPluginModelBase model = null;
        if (version == null || version.equals("0.0.0")) {
            model = PluginRegistry.findModel(this.id);
        } else {
            ModelEntry entry = PluginRegistry.findEntry(this.id);
            if (entry != null) {
                model = Arrays.stream(entry.getActiveModels()).filter(base -> base.getPluginBase().getVersion().equals(version)).findFirst().orElse(null);
            }
        }
        if (model != null) {
            return model.getPluginBase();
        }
        return null;
    }

    @Override
    public String getVersion() {
        return this.fVersion;
    }

    @Override
    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fVersion;
        this.fVersion = version;
        this.firePropertyChanged(this, "version", oldValue, version);
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        this.fVersion = this.getNodeAttribute(node, "version");
    }

    public void loadFrom(IPluginBase plugin) {
        this.id = plugin.getId();
        this.label = plugin.getTranslatedName();
        this.fVersion = plugin.getVersion();
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent + "<plugin");
        String indent2 = indent + "      ";
        this.writeAttributes(indent2, writer);
        if (this.getVersion() != null) {
            writer.println();
            writer.print(indent2 + "version=\"" + this.getVersion() + "\"");
        }
        writer.println("/>");
    }

    @Override
    public String getLabel() {
        IPluginBase pluginBase = this.getPluginBase();
        if (pluginBase != null) {
            return pluginBase.getTranslatedName();
        }
        String name = super.getLabel();
        if (name == null) {
            name = this.getId();
        }
        return name;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }
}

