/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class DisplayAction
extends EvaluateAction {
    @Override
    protected void displayResult(final IEvaluationResult evaluationResult) {
        if (evaluationResult.hasErrors()) {
            final Display display = JDIDebugUIPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    DisplayAction.this.reportErrors(evaluationResult);
                    DisplayAction.this.evaluationCleanup();
                }
            });
            return;
        }
        final String snippet = evaluationResult.getSnippet();
        IJavaValue resultValue = evaluationResult.getValue();
        try {
            String sig = null;
            IJavaType type = resultValue.getJavaType();
            if (type != null) {
                sig = type.getSignature();
            }
            if ("V".equals(sig)) {
                this.displayStringResult(snippet, ActionMessages.DisplayAction_no_result_value);
            } else {
                final String resultString = sig != null ? NLS.bind((String)ActionMessages.DisplayAction_type_name_pattern, (Object[])new Object[]{resultValue.getReferenceTypeName()}) : "";
                this.getDebugModelPresentation().computeDetail((IValue)resultValue, new IValueDetailListener(){

                    public void detailComputed(IValue value, String result) {
                        DisplayAction.this.displayStringResult(snippet, NLS.bind((String)ActionMessages.DisplayAction_result_pattern, (Object[])new Object[]{resultString, DisplayAction.trimDisplayResult(result)}));
                    }
                });
            }
        }
        catch (DebugException x) {
            this.displayStringResult(snippet, DisplayAction.getExceptionMessage(x));
        }
    }

    protected void displayStringResult(final String snippet, final String resultString) {
        final IDataDisplay directDisplay = this.getDirectDataDisplay();
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IDataDisplay dataDisplay;
                if (!display.isDisposed() && (dataDisplay = DisplayAction.this.getDataDisplay()) != null) {
                    if (directDisplay == null) {
                        dataDisplay.displayExpression(snippet);
                    }
                    dataDisplay.displayExpressionValue(DisplayAction.trimDisplayResult(resultString));
                }
                DisplayAction.this.evaluationCleanup();
            }
        });
    }

    @Override
    protected void run() {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof JavaSnippetEditor) {
            ((JavaSnippetEditor)part).evalSelection(1);
            return;
        }
        super.run();
    }

    public static String trimDisplayResult(String result) {
        int max = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
        if (max > 0 && ((String)result).length() > max) {
            result = ((String)result).substring(0, max) + "...";
        }
        return result;
    }
}

