/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.util.TestCodeUtil;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;

public class WorkingCopyCleanupListener
implements IElementChangedListener {
    public void elementChanged(ElementChangedEvent event) {
        Object o = event.getSource();
        if (o instanceof IJavaElementDelta) {
            IJavaElementDelta delta = (IJavaElementDelta)o;
            this.processElementDelta(delta);
        }
    }

    private void processElementDelta(IJavaElementDelta delta) {
        IJavaElementDelta[] deltas = delta.getAffectedChildren();
        if (deltas != null && deltas.length > 0) {
            int i = 0;
            while (i < deltas.length) {
                this.processElementDelta(deltas[i]);
                ++i;
            }
        }
        if (delta.getElement() instanceof ICompilationUnit) {
            boolean workingCopyDiscarded;
            ICompilationUnit cu = (ICompilationUnit)delta.getElement();
            boolean bl = cu.getOwner() == null ? !cu.isWorkingCopy() : (workingCopyDiscarded = !cu.exists());
            if (workingCopyDiscarded) {
                IJavaProject jp = cu.getJavaProject();
                GeneratedFileManager gfm = AptPlugin.getAptProject(jp).getGeneratedFileManager(TestCodeUtil.isTestCode(cu));
                try {
                    gfm.workingCopyDiscarded(cu);
                }
                catch (CoreException e) {
                    AptPlugin.log(e, "Failure processing delta: " + String.valueOf(delta));
                }
            }
        }
    }
}

