/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text.codemining.annotation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMining;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.ISourceViewerExtension5;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMining;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMiningFilter;
import org.eclipse.ui.internal.editors.text.codemining.annotation.AnnotationCodeMiningPreferences;

@NonNullByDefault
public class AnnotationCodeMiningProvider
extends AbstractCodeMiningProvider
implements AnnotationCodeMiningFilter.Locator {
    private @Nullable ITextViewer viewer = null;
    private @Nullable AnnotationModelListener annotationModelListener = null;
    private @Nullable PropertyChangeListener propertyChangeListener = null;
    private @Nullable IAnnotationAccessExtension annotationAccess = null;

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        if (!(viewer instanceof ISourceViewerExtension5)) {
            throw new IllegalArgumentException("Cannot attach to TextViewer without code mining support");
        }
        if (!new AnnotationCodeMiningPreferences().isEnabled()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        this.viewer = viewer;
        IAnnotationAccess annotationAccess = (IAnnotationAccess)this.getAdapter(IAnnotationAccess.class);
        if (!(annotationAccess instanceof IAnnotationAccessExtension)) {
            throw new IllegalStateException("annotationAccess must implement IAnnotationAccessExtension");
        }
        this.annotationAccess = (IAnnotationAccessExtension)annotationAccess;
        return this.provideCodeMiningsInternal(monitor);
    }

    public void dispose() {
        this.unregisterPropertyChangeListener();
        this.unregisterAnnotationModelListener();
        this.viewer = null;
        super.dispose();
    }

    @Override
    public @Nullable Integer getLine(Annotation annotation) {
        Integer offset = this.getOffset(annotation);
        if (offset == null) {
            return null;
        }
        try {
            return this.getDocument().getLineOfOffset(offset.intValue());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public @Nullable Integer getOffset(Annotation annotation) {
        Position position = this.getAnnotationModel().getPosition(annotation);
        if (position == null) {
            return null;
        }
        return position.getOffset();
    }

    private CompletableFuture<List<? extends ICodeMining>> provideCodeMiningsInternal(IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.checkAnnotationModelAvailable()) {
                return Collections.emptyList();
            }
            this.registerAnnotationModelListener();
            this.registerPropertyChangeListener();
            Stream<Annotation> annotations = this.getAnnotations();
            List<AbstractCodeMining> codeMinings = this.createCodeMinings(annotations, monitor);
            return codeMinings;
        });
    }

    private void registerAnnotationModelListener() {
        if (this.annotationModelListener == null) {
            this.annotationModelListener = new AnnotationModelListener();
            this.getAnnotationModel().addAnnotationModelListener((IAnnotationModelListener)this.annotationModelListener);
        }
    }

    private void unregisterAnnotationModelListener() {
        if (this.annotationModelListener != null) {
            this.getAnnotationModel().removeAnnotationModelListener((IAnnotationModelListener)this.annotationModelListener);
            this.annotationModelListener = null;
        }
    }

    private void registerPropertyChangeListener() {
        IPreferenceStore store;
        if (this.propertyChangeListener == null && (store = new AnnotationCodeMiningPreferences().getPreferences()) != null) {
            this.propertyChangeListener = new PropertyChangeListener();
            store.addPropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
        }
    }

    private void unregisterPropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            @Nullable IPreferenceStore store = new AnnotationCodeMiningPreferences().getPreferences();
            if (store != null) {
                store.removePropertyChangeListener((IPropertyChangeListener)this.propertyChangeListener);
            }
            this.propertyChangeListener = null;
        }
    }

    private Stream<Annotation> getAnnotations() {
        return new AnnotationCodeMiningFilter(this.getAnnotationAccess(), this.getAnnotationModel().getAnnotationIterator()).sortDistinctLimit(this);
    }

    private List<AbstractCodeMining> createCodeMinings(Stream<Annotation> annotations, IProgressMonitor monitor) {
        Stream<AbstractCodeMining> result = annotations.filter(m -> !monitor.isCanceled()).map(this::createCodeMining).filter(Objects::nonNull);
        return result.collect(Collectors.toList());
    }

    private @Nullable AbstractCodeMining createCodeMining(Annotation annotation) {
        Integer lineNumber = this.getLine(annotation);
        if (lineNumber == null) {
            return null;
        }
        try {
            Consumer<MouseEvent> action = this.createAction(annotation);
            return new AnnotationCodeMining(this.getAnnotationAccess(), annotation, lineNumber, this.getDocument(), (ICodeMiningProvider)this, action);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private @Nullable Consumer<MouseEvent> createAction(Annotation annotation) {
        if (!(annotation instanceof IQuickFixableAnnotation) || !(this.getTextViewer() instanceof ISourceViewerExtension3)) {
            return null;
        }
        Position position = this.getAnnotationModel().getPosition(annotation);
        if (position == null) {
            return null;
        }
        return e -> {
            IQuickFixableAnnotation quickFixableAnnotation = (IQuickFixableAnnotation)annotation;
            if (!quickFixableAnnotation.isQuickFixableStateSet() || !quickFixableAnnotation.isQuickFixable()) {
                return;
            }
            IQuickAssistAssistant quickAssistAssistant = ((ISourceViewerExtension3)this.getTextViewer()).getQuickAssistAssistant();
            if (quickAssistAssistant == null) {
                return;
            }
            if (!quickAssistAssistant.canFix(annotation)) {
                return;
            }
            this.getTextViewer().setSelectedRange(position.getOffset(), position.getLength());
            String message = quickAssistAssistant.showPossibleQuickAssists();
            if (message != null) {
                EditorsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.editors", message));
            }
        };
    }

    private boolean checkAnnotationModelAvailable() {
        return this.viewer != null && this.getAnnotationViewer().getVisualAnnotationModel() != null;
    }

    private IAnnotationModel getAnnotationModel() {
        return this.getAnnotationViewer().getVisualAnnotationModel();
    }

    private ITextViewer getTextViewer() {
        Assert.isNotNull((Object)this.viewer);
        return this.viewer;
    }

    private ISourceViewerExtension5 getCodeMiningViewer() {
        return (ISourceViewerExtension5)this.getTextViewer();
    }

    private ISourceViewerExtension2 getAnnotationViewer() {
        return (ISourceViewerExtension2)this.getTextViewer();
    }

    private IDocument getDocument() {
        return this.getTextViewer().getDocument();
    }

    private IAnnotationAccessExtension getAnnotationAccess() {
        Assert.isNotNull((Object)this.annotationAccess);
        return this.annotationAccess;
    }

    private class AnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private AnnotationModelListener() {
        }

        public void modelChanged(@Nullable IAnnotationModel model) {
        }

        public void modelChanged(AnnotationModelEvent event) {
            if (AnnotationCodeMiningProvider.this.viewer == null) {
                return;
            }
            if (!event.isValid() || event.isEmpty()) {
                return;
            }
            AnnotationCodeMiningFilter filter = new AnnotationCodeMiningFilter(AnnotationCodeMiningProvider.this.getAnnotationAccess(), event.getAddedAnnotations(), event.getRemovedAnnotations(), event.getChangedAnnotations());
            if (!filter.isEmpty()) {
                AnnotationCodeMiningProvider.this.getCodeMiningViewer().updateCodeMinings();
            }
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            switch (event.getProperty()) {
                case "showAnnotationAsCodeMiningMax": 
                case "showAnnotationAsCodeMiningLevel": {
                    AnnotationCodeMiningProvider.this.getCodeMiningViewer().updateCodeMinings();
                }
            }
        }
    }
}

