/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class WeavingAdaptorFactory {
    private static final Collection<String> IGNORE_WEAVING_SERVICE_BUNDLES = Arrays.asList("org.eclipse.equinox.weaving.aspectj", "org.eclipse.equinox.weaving.caching", "org.eclipse.equinox.weaving.caching.j9", "org.eclipse.update.configurator", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.equinox.common");
    private ServiceTracker<ICachingServiceFactory, ICachingServiceFactory> cachingServiceFactoryTracker;
    private PackageAdmin packageAdminService;
    private StartLevel startLevelService;
    private ISupplementerRegistry supplementerRegistry;
    private ServiceTracker<IWeavingServiceFactory, IWeavingServiceFactory> weavingServiceFactoryTracker;
    private ServiceListener weavingServiceListener;
    private final Map<Bundle, IWeavingService> weavingServices = new ConcurrentHashMap<Bundle, IWeavingService>();

    public void dispose(BundleContext bundleContext) {
        bundleContext.removeServiceListener(this.weavingServiceListener);
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Removed service listener for weaving service.");
        }
        this.weavingServiceFactoryTracker.close();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Closed service tracker for weaving service.");
        }
        this.cachingServiceFactoryTracker.close();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Closed service tracker for caching service.");
        }
    }

    protected ICachingService getCachingService(ModuleClassLoader moduleClassLoader, Bundle bundle, IWeavingService iWeavingService) {
        ICachingServiceFactory iCachingServiceFactory;
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptorFactory.getCachingService() bundle=" + bundle + ", weavingService=" + iWeavingService);
        }
        ICachingService iCachingService = null;
        String string = "";
        if (iWeavingService != null) {
            string = iWeavingService.getKey();
        }
        if ((iCachingServiceFactory = (ICachingServiceFactory)this.cachingServiceFactoryTracker.getService()) != null) {
            iCachingService = iCachingServiceFactory.createCachingService((ClassLoader)moduleClassLoader, bundle, string);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptorFactory.getCachingService() service=" + iCachingService + ", key='" + string + "'");
        }
        return iCachingService;
    }

    public Bundle getHost(Bundle bundle) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingAdaptorFactory.getHost() fragment=" + bundle);
        }
        Bundle bundle2 = null;
        if (this.packageAdminService != null) {
            bundle2 = this.packageAdminService.getHosts(bundle)[0];
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingAdaptorFactory.getHost() " + bundle2);
        }
        return bundle2;
    }

    protected IWeavingService getWeavingService(ModuleClassLoader moduleClassLoader) {
        IWeavingServiceFactory iWeavingServiceFactory;
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> WeavingAdaptorFactory.getWeavingService() baseClassLoader=" + moduleClassLoader);
        }
        BundleInfo.Generation generation = moduleClassLoader.getClasspathManager().getGeneration();
        Bundle bundle = moduleClassLoader.getBundle();
        IWeavingService iWeavingService = null;
        if (!IGNORE_WEAVING_SERVICE_BUNDLES.contains(bundle.getSymbolicName()) && (iWeavingServiceFactory = (IWeavingServiceFactory)this.weavingServiceFactoryTracker.getService()) != null && (iWeavingService = iWeavingServiceFactory.createWeavingService((ClassLoader)moduleClassLoader, bundle, (BundleRevision)generation.getRevision(), this.supplementerRegistry)) != null) {
            this.weavingServices.put(bundle, iWeavingService);
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< WeavingAdaptorFactory.getWeavingService() service=" + iWeavingService);
        }
        return iWeavingService;
    }

    public void initialize(BundleContext bundleContext, final ISupplementerRegistry iSupplementerRegistry) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingAdaptorFactory.initialize() context=" + bundleContext);
        }
        this.supplementerRegistry = iSupplementerRegistry;
        this.initializePackageAdminService(bundleContext);
        this.initializeStartLevelService(bundleContext);
        this.weavingServiceFactoryTracker = new ServiceTracker(bundleContext, IWeavingServiceFactory.class, null);
        this.weavingServiceFactoryTracker.open();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Opened service tracker for weaving service.");
        }
        this.weavingServiceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent serviceEvent) {
                Bundle bundle;
                Iterator iterator;
                Map map;
                ArrayList<Bundle> arrayList;
                if (serviceEvent.getType() == 1) {
                    arrayList = new ArrayList<Bundle>();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        iterator = WeavingAdaptorFactory.this.weavingServices.keySet().iterator();
                        while (iterator.hasNext()) {
                            bundle = (Bundle)iterator.next();
                            iterator.remove();
                            arrayList.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (arrayList.size() > 0) {
                        iSupplementerRegistry.refreshBundles(arrayList.toArray(new Bundle[arrayList.size()]));
                    }
                }
                if (serviceEvent.getType() == 4 && WeavingAdaptorFactory.this.startLevelService != null && WeavingAdaptorFactory.this.startLevelService.getStartLevel() > 0) {
                    arrayList = new ArrayList();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        iterator = WeavingAdaptorFactory.this.weavingServices.keySet().iterator();
                        while (iterator.hasNext()) {
                            bundle = (Bundle)iterator.next();
                            iterator.remove();
                            arrayList.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (arrayList.size() > 0) {
                        iSupplementerRegistry.refreshBundles(arrayList.toArray(new Bundle[arrayList.size()]));
                    }
                }
            }
        };
        try {
            bundleContext.addServiceListener(this.weavingServiceListener, "(objectClass=" + IWeavingServiceFactory.class.getName() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.cachingServiceFactoryTracker = new ServiceTracker(bundleContext, ICachingServiceFactory.class, null);
        this.cachingServiceFactoryTracker.open();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Opened service tracker for caching service.");
        }
    }

    private void initializePackageAdminService(BundleContext bundleContext) {
        ServiceReference serviceReference;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AdaptorFactory.initializePackageAdminService() context=" + bundleContext);
        }
        if ((serviceReference = bundleContext.getServiceReference(PackageAdmin.class)) != null) {
            this.packageAdminService = (PackageAdmin)bundleContext.getService(serviceReference);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AdaptorFactory.initializePackageAdminService() " + this.packageAdminService);
        }
    }

    private void initializeStartLevelService(BundleContext bundleContext) {
        ServiceReference serviceReference;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AdaptorFactory.initializeStartLevelService() context=" + bundleContext);
        }
        if ((serviceReference = bundleContext.getServiceReference(StartLevel.class)) != null) {
            this.startLevelService = (StartLevel)bundleContext.getService(serviceReference);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AdaptorFactory.initializeStartLevelService() " + this.startLevelService);
        }
    }
}

