/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.LauncherSupport;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.LaunchDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestClasses;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;

public class StandaloneLauncher {
    public static void main(String[] args) throws Exception {
        try {
            int numArgsConsumed;
            ForkedLaunch launchDefinition = null;
            ForkedExecution forkedExecution = new ForkedExecution();
            block17: for (int i = 0; i < args.length; i += numArgsConsumed) {
                String arg = args[i];
                numArgsConsumed = 1;
                switch (arg) {
                    case "--properties": {
                        Path propsPath = Paths.get(args[i + 1], new String[0]);
                        if (!Files.isRegularFile(propsPath, new LinkOption[0])) {
                            throw new IllegalArgumentException(propsPath + " does not point to a properties file");
                        }
                        Properties properties = new Properties();
                        try (InputStream is = Files.newInputStream(propsPath, new OpenOption[0]);){
                            properties.load(is);
                        }
                        forkedExecution.setProperties(properties);
                        numArgsConsumed = 2;
                        continue block17;
                    }
                    case "--launch-definition": {
                        Path launchDefXmlPath = Paths.get(args[i + 1], new String[0]);
                        if (!Files.isRegularFile(launchDefXmlPath, new LinkOption[0])) {
                            throw new IllegalArgumentException(launchDefXmlPath + " does not point to a launch definition file");
                        }
                        launchDefinition = StandaloneLauncher.parseLaunchDefinition(launchDefXmlPath);
                        numArgsConsumed = 2;
                        continue block17;
                    }
                }
            }
            LauncherSupport launcherSupport = new LauncherSupport(launchDefinition, forkedExecution);
            try {
                launcherSupport.launch();
            }
            catch (Throwable t) {
                if (launcherSupport.hasTestFailures()) {
                    System.exit(2);
                }
                throw t;
            }
            if (launcherSupport.hasTestFailures()) {
                System.exit(2);
                return;
            }
            System.exit(0);
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private static ForkedLaunch parseLaunchDefinition(Path pathToLaunchDefXml) {
        Object object;
        block24: {
            if (pathToLaunchDefXml == null || !Files.isRegularFile(pathToLaunchDefXml, new LinkOption[0])) {
                throw new IllegalArgumentException(pathToLaunchDefXml + " is not a file");
            }
            ForkedLaunch forkedLaunch = new ForkedLaunch();
            InputStream is = Files.newInputStream(pathToLaunchDefXml, new OpenOption[0]);
            try {
                String printSummary;
                String excludeTags;
                String includeTags;
                XMLStreamReader reader = XMLInputFactory.newFactory().createXMLStreamReader(is);
                reader.require(7, null, null);
                reader.nextTag();
                reader.require(1, null, "launch-definition");
                String haltOnfFailure = reader.getAttributeValue(null, "haltOnFailure");
                if (haltOnfFailure != null) {
                    forkedLaunch.setHaltOnFailure(Boolean.parseBoolean(haltOnfFailure));
                }
                if ((includeTags = reader.getAttributeValue(null, "includeTags")) != null) {
                    Stream.of(includeTags.split(",")).forEach(i -> forkedLaunch.addIncludeTag((String)i));
                }
                if ((excludeTags = reader.getAttributeValue(null, "excludeTags")) != null) {
                    Stream.of(excludeTags.split(",")).forEach(e -> forkedLaunch.addExcludeTag((String)e));
                }
                if ((printSummary = reader.getAttributeValue(null, "printSummary")) != null) {
                    forkedLaunch.setPrintSummary(Boolean.parseBoolean(printSummary));
                }
                if (haltOnfFailure != null) {
                    forkedLaunch.setHaltOnFailure(Boolean.parseBoolean(haltOnfFailure));
                }
                reader.nextTag();
                reader.require(1, null, null);
                String elementName = reader.getLocalName();
                switch (elementName) {
                    case "test": {
                        forkedLaunch.addTests(Collections.singletonList(SingleTestClass.fromForkedRepresentation(reader)));
                        break;
                    }
                    case "test-classes": {
                        forkedLaunch.addTests(TestClasses.fromForkedRepresentation(reader));
                        break;
                    }
                    case "listener": {
                        forkedLaunch.addListener(ListenerDefinition.fromForkedRepresentation(reader));
                    }
                }
                reader.nextTag();
                reader.require(2, null, "launch-definition");
                reader.next();
                reader.require(8, null, null);
                object = forkedLaunch;
                if (is == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new BuildException("Failed to construct definition from forked representation", (Throwable)e2);
                }
            }
            is.close();
        }
        return object;
    }

    private static final class ForkedLaunch
    implements LaunchDefinition {
        private boolean printSummary;
        private boolean haltOnFailure;
        private List<TestDefinition> tests = new ArrayList<TestDefinition>();
        private List<ListenerDefinition> listeners = new ArrayList<ListenerDefinition>();
        private List<String> includeTags = new ArrayList<String>();
        private List<String> excludeTags = new ArrayList<String>();

        private ForkedLaunch() {
        }

        @Override
        public List<TestDefinition> getTests() {
            return this.tests;
        }

        ForkedLaunch addTests(List<TestDefinition> tests) {
            this.tests.addAll(tests);
            return this;
        }

        @Override
        public List<ListenerDefinition> getListeners() {
            return this.listeners;
        }

        ForkedLaunch addListener(ListenerDefinition listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public boolean isPrintSummary() {
            return this.printSummary;
        }

        private ForkedLaunch setPrintSummary(boolean printSummary) {
            this.printSummary = printSummary;
            return this;
        }

        @Override
        public boolean isHaltOnFailure() {
            return this.haltOnFailure;
        }

        public ForkedLaunch setHaltOnFailure(boolean haltOnFailure) {
            this.haltOnFailure = haltOnFailure;
            return this;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }

        void addIncludeTag(String filter) {
            this.includeTags.add(filter);
        }

        @Override
        public List<String> getIncludeTags() {
            return this.includeTags;
        }

        void addExcludeTag(String filter) {
            this.excludeTags.add(filter);
        }

        @Override
        public List<String> getExcludeTags() {
            return this.excludeTags;
        }
    }

    private static final class ForkedExecution
    implements TestExecutionContext {
        private Properties properties = new Properties();

        private ForkedExecution() {
        }

        private ForkedExecution setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Optional<Project> getProject() {
            return Optional.empty();
        }
    }
}

