/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;

public class LineComparator
implements IRangeComparator {
    private String[] lines;
    private boolean ignoreWhiteSpace;

    public LineComparator(InputStream is, boolean ignoreWhiteSpace) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        this.lines = lines.toArray(new String[lines.size()]);
        this.ignoreWhiteSpace = ignoreWhiteSpace;
    }

    public String getLine(int index) {
        return this.lines[index];
    }

    public int getRangeCount() {
        return this.lines.length;
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        String line1 = this.lines[thisIndex];
        String line2 = ((LineComparator)other).lines[otherIndex];
        return this.ignoreWhiteSpace ? this.compare(line1, line2) : line1.equals(line2);
    }

    private boolean compare(String line1, String line2) {
        int c1 = 0;
        int c2 = 0;
        int i1 = 0;
        int i2 = 0;
        int l1 = line1.length();
        int l2 = line2.length();
        while (c1 != -1) {
            char c;
            c1 = -1;
            while (i1 < l1) {
                if (Character.isWhitespace(c = line1.charAt(i1++))) continue;
                c1 = c;
                break;
            }
            c2 = -1;
            while (i2 < l2) {
                if (Character.isWhitespace(c = line2.charAt(i2++))) continue;
                c2 = c;
                break;
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }
}

