/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.zephyr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.internal.zephyr.Messages;
import org.eclipse.rcptt.internal.zephyr.TestCaseResultModel;
import org.eclipse.rcptt.internal.zephyr.ZephyrConfigModel;
import org.eclipse.rcptt.internal.zephyr.ZephyrCycle;
import org.eclipse.rcptt.internal.zephyr.ZephyrPlugin;
import org.eclipse.rcptt.internal.zephyr.ZephyrProject;
import org.eclipse.rcptt.internal.zephyr.ZephyrRestClient;
import org.eclipse.rcptt.internal.zephyr.ZephyrTestCase;
import org.eclipse.rcptt.internal.zephyr.ZephyrVersion;
import org.eclipse.rcptt.launching.ITestEngine;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public final class ZephyrService
implements ITestEngine {
    public static final String ZEPHYR_ISSUE = "zephyr-issue";
    private static final String TEST_ENGINE_ENABLED = "enabled";
    private static final String ZEPHYR_CONFIG_ADDRESS_PARAM = "baseUrl";
    private static final String ZEPHYR_CONFIG_USERNAME_PARAM = "username";
    private static final String ZEPHYR_CONFIG_PASSWORD_PARAM = "password";
    private boolean zephyrEnabled;
    private ZephyrConfigModel config;
    private static final String TESTRESULT_CONTEXT_PREFIX = "__Contexts:__ ";
    private static final String TESTRESULT_FAILMSG_PREFIX = "__Fail message:__\n";

    public void testRunStarted(Map<String, String> config, List<Q7TestCase> tests) {
    }

    public void testRunCompleted() {
    }

    public void sessionStarted(ExecutionSession session) {
    }

    public void sessionCompleted(ExecutionSession session) {
    }

    public void executionStarted(EclScenarioExecutable scenario, Map<String, String> config) {
        this.applyConfig(scenario, config);
        if (!this.zephyrEnabled) {
            return;
        }
        String issueName = this.getIssue((Q7TestCase)scenario.getActualElement());
        this.config.setIssueName(issueName);
    }

    public void executionCompleted(EclScenarioExecutable scenario, Report report) {
        if (!this.zephyrEnabled) {
            return;
        }
        Boolean passed = this.getZephyrStatus(scenario);
        if (passed == null) {
            return;
        }
        TestCaseResultModel testcase = new TestCaseResultModel(passed, this.getZephyrComment(scenario, report));
        this.config.setTestcase(testcase);
        ZephyrTestCase.processTestCaseDetails(this.config);
        this.config.getRestClient().destroy();
    }

    private void applyConfig(EclScenarioExecutable scenario, Map<String, String> config) {
        String address = config.get(ZEPHYR_CONFIG_ADDRESS_PARAM);
        String username = config.get(ZEPHYR_CONFIG_USERNAME_PARAM);
        String password = config.get(ZEPHYR_CONFIG_PASSWORD_PARAM);
        IProject rcpttProject = this.getIProject(scenario);
        String projectKey = ZephyrPlugin.getZephyrProject(rcpttProject);
        String versionKey = ZephyrPlugin.getZephyrVersion(rcpttProject);
        String cycleKey = ZephyrPlugin.getZephyrCycle(rcpttProject);
        this.zephyrEnabled = true;
        this.config = this.initializeZephyrData(address, username, password, projectKey, versionKey, cycleKey);
        ZephyrPlugin.logInfo(Messages.ZephyrService_SuccessfullyCreatedClient);
    }

    private Boolean getZephyrStatus(EclScenarioExecutable scenario) {
        int severity = scenario.getResultStatus().getSeverity();
        switch (severity) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 4: {
                return false;
            }
            case 8: {
                return null;
            }
        }
        return null;
    }

    private String getZephyrComment(EclScenarioExecutable scenario, Report report) {
        int testCaseSeveriry;
        String testCaseComment = "";
        List variantName = scenario.getVariantName();
        if (variantName != null && !variantName.isEmpty()) {
            String contextNames = variantName.stream().collect(Collectors.joining(", ")).toString();
            testCaseComment = TESTRESULT_CONTEXT_PREFIX + contextNames;
        }
        if ((testCaseSeveriry = scenario.getResultStatus().getSeverity()) == 4) {
            if (!testCaseComment.equals("")) {
                testCaseComment = String.valueOf(testCaseComment) + "\n\n";
            }
            Node reportRoot = report.getRoot();
            testCaseComment = String.valueOf(testCaseComment) + TESTRESULT_FAILMSG_PREFIX + ReportUtils.getFailMessage((Node)reportRoot);
        }
        return testCaseComment;
    }

    public String validateParameter(String name, String value) {
        return null;
    }

    public Map<String, Long> getAllProjects() {
        return ZephyrProject.getAllProjects(this.getRestClient());
    }

    public Map<String, Long> getAllVersions(Long zephyrProject) {
        return ZephyrVersion.getAllVersions(this.getRestClient(), zephyrProject);
    }

    public Map<String, Long> getAllCycles(Long zephyrProject, Long zephyrVersion) {
        return ZephyrCycle.getAllCycles(this.getRestClient(), zephyrProject, zephyrVersion);
    }

    private ZephyrRestClient getRestClient() {
        String host = ZephyrPlugin.getZephyrAddress();
        String username = ZephyrPlugin.getZephyrUsername();
        String password = ZephyrPlugin.getZephyrPassword();
        return new ZephyrRestClient(host, username, password);
    }

    private String getIssue(Q7TestCase testCase) {
        String testCaseId;
        block3: {
            try {
                testCaseId = (String)testCase.getProperties().get(ZEPHYR_ISSUE);
                if (testCaseId != null) break block3;
                ZephyrPlugin.logInfo(MessageFormat.format(Messages.ZephyrService_TestCasePropertyIsNotSpecified, ZEPHYR_ISSUE));
                return null;
            }
            catch (Exception e) {
                ZephyrPlugin.log(MessageFormat.format(Messages.ZephyrService_ErrorWhileGettingTestCaseProperty, ZEPHYR_ISSUE), e);
                return null;
            }
        }
        return testCaseId;
    }

    public IStatus doTestConnection(String host, String username, String password) {
        String serverAddress = StringUtils.removeEnd((String)host, (String)"/");
        if (StringUtils.isBlank((CharSequence)serverAddress)) {
            return ZephyrPlugin.createStatus(4, "Please enter the server name");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return ZephyrPlugin.createStatus(4, "Please enter the username");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            return ZephyrPlugin.createStatus(4, "Please enter the password");
        }
        if (!serverAddress.trim().startsWith("https://") && !serverAddress.trim().startsWith("http://")) {
            return ZephyrPlugin.createStatus(4, "Incorrect server address format");
        }
        String jiraURL = ZephyrService.validateURL(serverAddress);
        if (!jiraURL.startsWith("http")) {
            return ZephyrPlugin.createStatus(4, jiraURL);
        }
        ZephyrRestClient restClient = new ZephyrRestClient(serverAddress, username, password);
        if (!restClient.validateConnection()) {
            return ZephyrPlugin.createStatus(4, "This is not a valid Jira Server");
        }
        if (!restClient.validateCredentials()) {
            return ZephyrPlugin.createStatus(4, "Invalid user credentials");
        }
        restClient.destroy();
        return ZephyrPlugin.createStatus(0, "Connection to JIRA has been validated");
    }

    public static String validateURL(String string) {
        StringBuilder builder = new StringBuilder();
        try {
            URL url = new URL(string);
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            builder.append(url.getProtocol());
            builder.append("://");
            builder.append(url.getHost());
            int port = url.getPort();
            if (port > 0) {
                builder.append(":");
                builder.append(port);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return Messages.ZephyrService_UrlInvalid;
        }
        catch (SSLException sSLException) {
            return Messages.ZephyrService_UrlSslError;
        }
        catch (IOException iOException) {
            return Messages.ZephyrService_UrlConnectionError;
        }
        return builder.toString();
    }

    private ZephyrConfigModel initializeZephyrData(String host, String username, String password, String projectKey, String versionKey, String cycleKey) {
        ZephyrConfigModel zephyrConfig = new ZephyrConfigModel();
        zephyrConfig.setRestClient(new ZephyrRestClient(host, username, password));
        zephyrConfig.setTestIssueTypeId(zephyrConfig.getRestClient().findZephyrTypeId());
        zephyrConfig.setZephyrProjectId(ZephyrProject.getProjectIdByName(projectKey, zephyrConfig.getRestClient()));
        zephyrConfig.setVersionId(ZephyrVersion.getVersionIdByName(zephyrConfig.getRestClient(), zephyrConfig.getProjectId(), versionKey));
        zephyrConfig.setCycleId(ZephyrCycle.getCycleIdByName(zephyrConfig.getRestClient(), zephyrConfig.getProjectId(), zephyrConfig.getVersionId(), cycleKey));
        return zephyrConfig;
    }

    private IProject getIProject(EclScenarioExecutable scenario) {
        return scenario.getActualElement().getParent().getParent().getQ7Project().getProject();
    }

    public void setConfiguration(Map<String, String> config) {
        String isEnabled = config.get(TEST_ENGINE_ENABLED);
        boolean state = isEnabled == null ? true : Boolean.getBoolean(isEnabled);
        ZephyrPlugin.setZephyrEnabled(state);
        String address = config.get(ZEPHYR_CONFIG_ADDRESS_PARAM);
        ZephyrPlugin.setZephyrAddress(address);
        String username = config.get(ZEPHYR_CONFIG_USERNAME_PARAM);
        ZephyrPlugin.setZephyrUsername(username);
        String password = config.get(ZEPHYR_CONFIG_PASSWORD_PARAM);
        ZephyrPlugin.setZephyrPassword(password);
    }

    public Map<String, String> getConfiguration() {
        HashMap<String, String> config = new HashMap<String, String>();
        boolean isEnabled = ZephyrPlugin.getZephyrEnabled();
        config.put(TEST_ENGINE_ENABLED, Boolean.toString(isEnabled));
        String address = ZephyrPlugin.getZephyrAddress();
        config.put(ZEPHYR_CONFIG_ADDRESS_PARAM, address);
        String username = ZephyrPlugin.getZephyrUsername();
        config.put(ZEPHYR_CONFIG_USERNAME_PARAM, username);
        String password = ZephyrPlugin.getZephyrPassword();
        config.put(ZEPHYR_CONFIG_PASSWORD_PARAM, password);
        return config;
    }
}

