/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.EOFException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;

public class TestSuiteUtils {
    private static final Map<IQ7Element.HandleType, ItemKind> typeMapping;

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)IQ7Element.HandleType.Context, (Object)ItemKind.CONTEXT);
        b.put((Object)IQ7Element.HandleType.TestCase, (Object)ItemKind.TESTCASE);
        b.put((Object)IQ7Element.HandleType.TestSuite, (Object)ItemKind.TEST_SUITE);
        b.put((Object)IQ7Element.HandleType.Verification, (Object)ItemKind.VERIFICATION);
        typeMapping = b.build();
    }

    public static String toString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)writer, false);
        e.printStackTrace(printWriter);
        printWriter.close();
        return writer.toString();
    }

    static IStatus getRootCause(IStatus status) {
        if (status == null) {
            return null;
        }
        IStatus[] children = status.getChildren();
        int i = children.length - 1;
        while (i >= 0) {
            IStatus child = children[i];
            IStatus rv = TestSuiteUtils.getRootCause(child);
            if (rv != null && rv.matches(12)) {
                return rv;
            }
            --i;
        }
        return status;
    }

    public static Throwable getRootCause(Throwable e) {
        IStatus status;
        if (e == null) {
            return null;
        }
        Throwable rootCause = e;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof CoreException && (status = TestSuiteUtils.getRootCause(((CoreException)rootCause).getStatus())) != null && status.getException() != null) {
            return TestSuiteUtils.getRootCause(status.getException());
        }
        return rootCause;
    }

    public static boolean isConnectionProblem(Throwable e) {
        return (e = TestSuiteUtils.getRootCause(e)) instanceof EOFException || e instanceof SocketException || e instanceof TimeoutException;
    }

    public static IQ7NamedElement[] getElements(ILaunchConfiguration config) throws CoreException {
        return TestSuiteUtils.getElements(config, false);
    }

    public static IQ7NamedElement[] getElements(ILaunchConfiguration config, boolean excludeNonExistent) throws CoreException {
        boolean includeContext = config.getAttribute("org.eclipse.rcptt.launching.INCLUDE_CONTEXT_ATTR", false);
        boolean noSort = config.getAttribute("org.eclipse.rcptt.launching.NO_SORT", false);
        IResource[] mappedResources = config.getMappedResources();
        int resources = config.getAttribute("q7.exec.resources", -1);
        if (resources > 0) {
            ArrayList<IResource> result = new ArrayList<IResource>();
            int i = 0;
            while (i < resources) {
                IResource resource = mappedResources[i];
                if (resource.exists() && resource.getProject().isOpen()) {
                    result.add(resource);
                }
                ++i;
            }
            return TestSuiteUtils.getElements(result.toArray(new IResource[result.size()]), !includeContext, !noSort);
        }
        return TestSuiteUtils.getElements(config.getMappedResources(), !includeContext, !noSort);
    }

    public static IQ7NamedElement[] getElements(IResource[] resources, boolean filterContext, boolean sort) {
        ArrayList<IQ7NamedElement> elements = new ArrayList<IQ7NamedElement>();
        HashSet<IResource> checked = new HashSet<IResource>();
        if (resources != null) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                TestSuiteUtils.collect(resource, elements, checked, filterContext);
                ++n2;
            }
            if (sort) {
                SortingUtils.sortNamedElements(elements);
            }
        }
        return elements.toArray(new IQ7NamedElement[elements.size()]);
    }

    public static IQ7NamedElement[] getElements(IResource[] resources, boolean filterContext) {
        return TestSuiteUtils.getElements(resources, filterContext, true);
    }

    private static void collect(IResource resource, List<IQ7NamedElement> elements, Set<IResource> checked, boolean filterContext) {
        if (checked.contains(resource)) {
            return;
        }
        checked.add(resource);
        try {
            if (resource instanceof IFile) {
                IQ7NamedElement element = (IQ7NamedElement)RcpttCore.create((IResource)resource);
                if (element != null && (!filterContext || element instanceof ITestCase || element instanceof ITestSuite)) {
                    elements.add(element);
                }
            } else if (resource instanceof IContainer && (!(resource instanceof IProject) || ((IProject)resource).isOpen())) {
                IResource[] members;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    TestSuiteUtils.collect(member, elements, checked, filterContext);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public static Report generateFailedReport(IQ7NamedElement element, String errorMessage) {
        return TestSuiteUtils.generateReport(element, RcpttPlugin.createStatus((String)errorMessage));
    }

    public static Report generateSkippedReport(IQ7NamedElement iq7NamedElement, String errorMessage) {
        return TestSuiteUtils.generateReport(iq7NamedElement, (IStatus)new Status(8, "org.eclipse.rcptt.core", errorMessage));
    }

    public static ItemKind toItemKind(IQ7Element.HandleType type) {
        ItemKind rv = typeMapping.get(type);
        Preconditions.checkArgument((rv != null ? 1 : 0) != 0, (Object)("Can't convert item type " + type + " to report type"));
        return rv;
    }

    public static Report generateReport(IQ7NamedElement element, IStatus status) {
        try {
            Report report = ReportFactory.eINSTANCE.createReport();
            Node root = ReportFactory.eINSTANCE.createNode();
            root.setName(element.getID());
            report.setRoot(root);
            Q7Info q7info = TestSuiteUtils.getQ7Info(element);
            q7info.setResult(ProcessStatusConverter.toProcessStatus((IStatus)status));
            root.getProperties().put((Object)"q7", (Object)q7info);
            root.setName(element.getElementName());
            return report;
        }
        catch (ModelException e) {
            Q7LaunchingPlugin.log(e);
            Report report = ReportFactory.eINSTANCE.createReport();
            Node root = ReportFactory.eINSTANCE.createNode();
            root.setName(element.getPath().toString());
            report.setRoot(root);
            Q7Info q7info = ReportingFactory.eINSTANCE.createQ7Info();
            q7info.setId(element.getPath().toString());
            ProcessStatus pstatus = CoreFactory.eINSTANCE.createProcessStatus();
            pstatus.setSeverity(4);
            pstatus.setPluginId("org.eclipse.rcptt.core");
            pstatus.setMessage("Failed to generate simple report: " + e.getMessage());
            q7info.setResult(pstatus);
            q7info.setType(ItemKind.TESTCASE);
            root.getProperties().put((Object)"q7", (Object)q7info);
            root.setName(element.getPath().toString());
            return report;
        }
    }

    public static AutLaunch SelectAUT() throws CoreException {
        Status status = new Status(4, "org.eclipse.rcptt.launching", 123128, "", null);
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (handler != null) {
            return (AutLaunch)handler.handleStatus((IStatus)status, null);
        }
        return null;
    }

    public static Q7Info getQ7Info(IQ7NamedElement element) throws ModelException {
        Q7Info info = ReportingFactory.eINSTANCE.createQ7Info();
        info.setType(TestSuiteUtils.toItemKind(element.getElementType()));
        Preconditions.checkNotNull((Object)info.getType());
        info.setDescription(element.getDescription());
        info.setId(element.getID());
        info.setTags(element.getTags());
        return info;
    }
}

