/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.egit.ui.internal.history.IFindListener;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;

public class FindResults {
    private Map<Integer, Integer> matchesMap = new LinkedHashMap<Integer, Integer>();
    private List<RevObject> revObjList = new ArrayList<RevObject>();
    Integer[] keysArray;
    private int matchesCount;
    private RevFlag highlight;
    private boolean overflow;
    private final CopyOnWriteArrayList<IFindListener> listeners = new CopyOnWriteArrayList();

    public void addFindListener(IFindListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeFindListener(IFindListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized boolean isFoundAt(int index) {
        return this.matchesMap.containsKey(index);
    }

    public synchronized int getIndexAfter(int index) {
        Object[] matches = this.getkeysArray();
        int sres = Arrays.binarySearch(matches, (Object)index);
        if (sres >= 0 && sres != matches.length - 1) {
            return (Integer)matches[sres + 1];
        }
        if (sres < 0 && (sres = -sres - 1) < matches.length) {
            return (Integer)matches[sres];
        }
        return -1;
    }

    public synchronized int getIndexBefore(int index) {
        Object[] matches = this.getkeysArray();
        int sres = Arrays.binarySearch(matches, (Object)index);
        if (sres >= 0 && sres != 0) {
            return (Integer)matches[sres - 1];
        }
        if (sres < -1) {
            sres = -sres;
            return (Integer)matches[sres - 2];
        }
        return -1;
    }

    public synchronized int getFirstIndex() {
        Iterator<Integer> iter = this.matchesMap.keySet().iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return -1;
    }

    public synchronized int getLastIndex() {
        Integer[] matches = this.getkeysArray();
        if (matches.length > 0) {
            return matches[matches.length - 1];
        }
        return -1;
    }

    public synchronized int getMatchNumberFor(int index) {
        Integer ix = this.matchesMap.get(index);
        if (ix != null) {
            return ix;
        }
        return -1;
    }

    public int size() {
        return this.matchesCount;
    }

    public synchronized void clear() {
        if (this.highlight != null) {
            for (RevObject o : this.revObjList) {
                o.remove(this.highlight);
            }
        }
        this.matchesMap.clear();
        this.revObjList.clear();
        this.keysArray = null;
        boolean hadItems = this.matchesCount > 0;
        this.matchesCount = 0;
        if (hadItems) {
            for (IFindListener listener : this.listeners) {
                listener.cleared();
            }
        }
    }

    public synchronized void add(int matchIx, RevObject revObj) {
        this.matchesMap.put(matchIx, ++this.matchesCount);
        this.revObjList.add(revObj);
        revObj.add(this.highlight);
        this.keysArray = null;
        for (IFindListener listener : this.listeners) {
            listener.itemAdded(matchIx, revObj);
        }
    }

    private Integer[] getkeysArray() {
        if (this.keysArray == null) {
            this.keysArray = this.matchesMap.keySet().toArray(new Integer[this.matchesMap.size()]);
        }
        return this.keysArray;
    }

    synchronized void setHighlightFlag(RevFlag hFlag) {
        if (this.highlight != null) {
            this.clear();
        }
        this.highlight = hFlag;
    }

    synchronized void setOverflow() {
        this.overflow = true;
    }

    synchronized boolean isOverflow() {
        return this.overflow;
    }
}

