/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.properties.view;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;
import org.eclipse.rcptt.tesla.internal.ui.player.AbstractSWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.ISWTUIPlayerExtension;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyList;

public class PropertiesViewProcessor
implements ITeslaCommandProcessor {
    private AbstractTeslaClient client;
    private SWTUIProcessor swtUIProcessor;
    private ISWTUIPlayerExtension extension = new AbstractSWTUIPlayerExtension(){

        public GenericElementKind getKind(Object w) {
            if (w instanceof TabbedPropertyList.ListElement) {
                return new GenericElementKind(ElementKind.PropertyTab);
            }
            return null;
        }
    };

    public int getPriority() {
        return 125;
    }

    public PropertiesViewProcessor() {
        SWTUIPlayer.addExtension((ISWTUIPlayerExtension)this.extension);
    }

    public String getFeatureID() {
        return "swt.properties.view";
    }

    public boolean isSelectorSupported(String kind) {
        return kind.equals(ElementKind.PropertyTab.name());
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        if (!cmd.getData().getKind().equals(ElementKind.PropertyTab.name())) {
            return null;
        }
        SWTUIElement swtuiElement = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(cmd.getData().getParent());
        if (swtuiElement == null) {
            return PropertiesViewProcessor.selectError("Unable to resolve parent element (SWTUIElement).", new Object[0]);
        }
        if (!(swtuiElement instanceof WorkbenchUIElement)) {
            return PropertiesViewProcessor.selectError("Unable to resolve parent element (WorkbenchUIElement).", new Object[0]);
        }
        WorkbenchUIElement workbenchUIElement = (WorkbenchUIElement)swtuiElement;
        IWorkbenchPartReference iWorkbenchPartReference = workbenchUIElement.getReference();
        if (!(iWorkbenchPartReference instanceof WorkbenchPartReference)) {
            return PropertiesViewProcessor.selectError("Unable to resolve parent element (WorkbenchPartReference).", new Object[0]);
        }
        WorkbenchPartReference workbenchPartReference = (WorkbenchPartReference)iWorkbenchPartReference;
        final Control control = workbenchPartReference.getPane().getControl();
        if (control == null || !(control instanceof Composite)) {
            return PropertiesViewProcessor.selectError("Unable to resolve parent element (Control).", new Object[0]);
        }
        final String text = cmd.getData().getPattern();
        final AtomicReference tab = new AtomicReference();
        control.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object e;
                TabbedPropertyComposite tabbedPropertyComposite = (TabbedPropertyComposite)PropertiesViewProcessor.findVisibleChild(TabbedPropertyComposite.class, (Composite)control);
                if (tabbedPropertyComposite == null) {
                    return;
                }
                TabbedPropertyList list = tabbedPropertyComposite.getList();
                int i = 0;
                while ((e = list.getElementAt(i)) != null) {
                    TabbedPropertyList.ListElement listElement;
                    if (e instanceof TabbedPropertyList.ListElement && (listElement = (TabbedPropertyList.ListElement)e).getTabItem().getText().equals(text)) {
                        tab.set(listElement);
                        break;
                    }
                    ++i;
                }
            }
        });
        if (tab.get() == null) {
            return PropertiesViewProcessor.selectError("Property tab \"%s\" is not found.", text);
        }
        swtuiElement = this.getSWTUIProcessor().getPlayer().wrap(tab.get());
        Element element = this.getSWTUIProcessor().getMapper().get((IBasicMappingNode)swtuiElement);
        SelectResponse selectResponse = ProtocolFactory.eINSTANCE.createSelectResponse();
        selectResponse.getElements().add((Object)element);
        return selectResponse;
    }

    public boolean isCommandSupported(Command cmd) {
        return cmd instanceof Click;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        if (!(command instanceof Click)) {
            return null;
        }
        Click click = (Click)command;
        SWTUIElement swtuiElement = (SWTUIElement)this.getSWTUIProcessor().getMapper().get(click.getElement());
        Widget widget = swtuiElement.widget;
        if (!(widget instanceof TabbedPropertyList.ListElement)) {
            return PropertiesViewProcessor.executeError("Unsupported widget class \"%s\".", widget.getClass().getName());
        }
        TabbedPropertyList.ListElement listElement = (TabbedPropertyList.ListElement)widget;
        final TabbedPropertyComposite tabbedPropertyComposite = PropertiesViewProcessor.findParent(TabbedPropertyComposite.class, (Control)listElement);
        if (tabbedPropertyComposite == null) {
            return PropertiesViewProcessor.executeError("Tabbed property composite is not found.", new Object[0]);
        }
        final TabbedPropertyList tabbedPropertyList = tabbedPropertyComposite.getList();
        int i = 0;
        while (true) {
            Object e;
            if ((e = tabbedPropertyList.getElementAt(i)) == listElement) {
                final int index = i;
                final AtomicBoolean success = new AtomicBoolean(false);
                tabbedPropertyList.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (tabbedPropertyComposite.isVisible()) {
                            TeslaSWTAccess.callMethod(TabbedPropertyList.class, (Object)tabbedPropertyList, (String)"select", (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{index});
                            success.set(true);
                        }
                    }
                });
                if (success.get()) {
                    return PropertiesViewProcessor.executeSuccess();
                }
                return PropertiesViewProcessor.executeError("Property tab \"%s\" is not visible.", listElement.getTabItem().getText());
            }
            if (e == null) break;
            ++i;
        }
        return PropertiesViewProcessor.executeError("Property tab \"%s\" is not found.", listElement.getTabItem().getText());
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
    }

    public boolean isInactivityRequired() {
        return false;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
    }

    public void terminate() {
        SWTUIPlayer.removeExtension((ISWTUIPlayerExtension)this.extension);
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void notifyUI() {
    }

    private SWTUIProcessor getSWTUIProcessor() {
        if (this.swtUIProcessor == null) {
            this.swtUIProcessor = (SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class);
        }
        return this.swtUIProcessor;
    }

    private static Status error(String message, Object ... args) {
        return new Status(4, "org.eclipse.rcptt.tesla.properties.view", String.format(message, args));
    }

    private static SelectResponse selectError(String message, Object ... args) {
        SelectResponse selectResponse = ProtocolFactory.eINSTANCE.createSelectResponse();
        selectResponse.setStatus(ResponseStatus.FAILED);
        selectResponse.setMessage(String.format(message, args));
        return selectResponse;
    }

    private static Response executeError(String message, Object ... args) {
        Response response = RawFactory.eINSTANCE.createResponse();
        response.setStatus(ResponseStatus.FAILED);
        response.setMessage(String.format(message, args));
        return response;
    }

    private static Response executeSuccess() {
        Response response = RawFactory.eINSTANCE.createResponse();
        response.setStatus(ResponseStatus.OK);
        return response;
    }

    private static <T> T findVisibleChild(Class<T> class_, Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            T result;
            Control c = controlArray[n2];
            if (class_ == c.getClass() && c.isVisible()) {
                return class_.cast(c);
            }
            if (c instanceof Composite && (result = PropertiesViewProcessor.findVisibleChild(class_, (Composite)c)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private static <T> T findParent(Class<T> class_, Control child) {
        do {
            if ((child = child.getParent()).getClass() != class_) continue;
            return class_.cast(child);
        } while (child != null);
        return null;
    }
}

