/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ecl.internal.impl.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.util.CommandToStringConverter;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.ecl.runtime.ISession;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.ecl.internal.impl.TeslaImplPlugin;
import org.eclipse.rcptt.tesla.ecl.model.VerifyError;
import org.eclipse.rcptt.tesla.internal.core.queue.TeslaQClient;
import org.eclipse.ui.PlatformUI;

public class VerifyErrorService
implements ICommandService {
    public IStatus service(Command command, IProcess process) throws InterruptedException, CoreException {
        TeslaBridge.waitDelay();
        VerifyError verify = (VerifyError)command;
        ISession session = process.getSession();
        Command c = verify.getCommand();
        TeslaBridge.beginNoErrorMode();
        try {
            IStatus result = session.execute(c, process.getInput(), null).waitFor();
            final TeslaQClient client = TeslaBridge.getClient();
            if (client != null) {
                client.clearLastFailureInformation();
            }
            TeslaBridge.getLastInfo();
            if (result.isOK()) {
                TeslaBridge.endNoErrorMode();
                if (client != null) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            client.collectLastFailureInformation();
                        }
                    });
                }
                String msg = "Command " + new CommandToStringConverter().convert(c) + " succeed, but expected error.";
                TeslaBridge.makeScreenshot(true, msg);
                IStatus iStatus = TeslaImplPlugin.error(msg);
                return iStatus;
            }
        }
        finally {
            TeslaBridge.endNoErrorMode();
        }
        return Status.OK_STATUS;
    }
}

