/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ClassPathContainer
extends PackageFragmentRootContainer {
    private IClasspathEntry fClassPathEntry;
    private IClasspathContainer fContainer;

    public ClassPathContainer(IJavaProject parent, IClasspathEntry entry) {
        super(parent);
        this.fClassPathEntry = entry;
        try {
            this.fContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)parent);
        }
        catch (JavaModelException javaModelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassPathContainer) {
            ClassPathContainer other = (ClassPathContainer)obj;
            if (this.getJavaProject().equals(other.getJavaProject()) && this.fClassPathEntry.equals(other.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getJavaProject().hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    @Override
    public IPackageFragmentRoot[] getPackageFragmentRoots() {
        return this.getJavaProject().findPackageFragmentRoots(this.fClassPathEntry);
    }

    @Override
    public IAdaptable[] getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            list.add(roots[i]);
            ++i;
        }
        if (this.fContainer != null) {
            IClasspathEntry[] classpathEntries = this.fContainer.getClasspathEntries();
            if (classpathEntries == null) {
                JavaPlugin.log(new IllegalArgumentException("Invalid classpath container implementation: getClasspathEntries() returns null. " + this.fContainer.getPath()));
            } else {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int i2 = 0;
                while (i2 < classpathEntries.length) {
                    IResource resource;
                    IClasspathEntry entry = classpathEntries[i2];
                    if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                        list.add(new RequiredProjectWrapper(this, JavaCore.create((IProject)((IProject)resource))));
                    }
                    ++i2;
                }
            }
        }
        return list.toArray(new IAdaptable[list.size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_LIBRARY;
    }

    @Override
    public String getLabel() {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fClassPathEntry.getPath();
        String containerId = path.segment(0);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.getJavaProject());
            return Messages.format(PackagesMessages.ClassPathContainer_unbound_label, description);
        }
        return Messages.format(PackagesMessages.ClassPathContainer_unknown_label, BasicElementLabels.getPathLabel((IPath)path, (boolean)false));
    }

    public IClasspathEntry getClasspathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IJavaProject project, IClasspathEntry entry, IPackageFragmentRoot root) {
        IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final ClassPathContainer fParent;
        private final IJavaProject fProject;

        public RequiredProjectWrapper(ClassPathContainer parent, IJavaProject project) {
            this.fParent = parent;
            this.fProject = project;
        }

        public IJavaProject getProject() {
            return this.fProject;
        }

        public ClassPathContainer getParentClassPathContainer() {
            return this.fParent;
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return (T)this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return this.fParent;
        }
    }
}

