/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.utils;

import java.io.PrintWriter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoNode;
import org.eclipse.rcptt.tesla.core.info.JobEntry;
import org.eclipse.rcptt.tesla.core.info.NodeProperty;
import org.eclipse.rcptt.tesla.core.info.StackTraceEntry;

public class AdvancedInformationGenerator {
    private final PrintWriter writer;

    public AdvancedInformationGenerator(PrintWriter writer) {
        this.writer = writer;
    }

    private PrintWriter w(int tabs) {
        int i = 0;
        while (i < tabs) {
            this.writer.append("  ");
            ++i;
        }
        return this.writer;
    }

    public void writeAdvanced(AdvancedInformation info, int tabs) {
        EList<StackTraceEntry> threads;
        EList<InfoNode> nodes = info.getNodes();
        for (InfoNode infoNode : nodes) {
            this.printNode(infoNode, tabs);
        }
        EList<JobEntry> jobs = info.getJobs();
        if (!jobs.isEmpty()) {
            this.w(tabs).println("Jobs information:");
            for (JobEntry jobEntry : jobs) {
                this.w(tabs + 1).println("Job:" + jobEntry.getName());
                this.w(tabs + 3).println("class=" + jobEntry.getJobClass());
                this.w(tabs + 3).println("state=" + jobEntry.getState());
                if (jobEntry.getRule() == null) continue;
                this.w(tabs + 4).println("rule=" + jobEntry.getRule());
            }
        }
        if (!(threads = info.getThreads()).isEmpty()) {
            this.w(tabs + 0).println("Thread information:");
            for (StackTraceEntry trace : threads) {
                if (trace.getThreadClass().equals("org.eclipse.core.internal.jobs.Worker") && trace.getStackTrace().size() == 4) continue;
                this.w(tabs + 2).println("Thread:" + trace.getThreadName());
                this.w(tabs + 3).println("class=" + trace.getThreadClass());
                EList<String> list = trace.getStackTrace();
                int i = 0;
                while (i < list.size()) {
                    this.w(tabs + 4).append(Integer.toString(list.size() - i - 1)).append(": ").append((CharSequence)list.get(i)).println();
                    ++i;
                }
            }
        }
    }

    private void printNode(InfoNode infoNode, int tabs) {
        this.writer.println();
        this.w(tabs).print(infoNode.getName());
        EList<NodeProperty> list = infoNode.getProperties();
        EList<InfoNode> childs = infoNode.getChildren();
        if (!list.isEmpty() || !childs.isEmpty()) {
            if (list.size() != 0) {
                this.writer.println();
                for (NodeProperty nodeProperty : list) {
                    this.w(tabs + 2).println(String.valueOf(nodeProperty.getName()) + "=" + nodeProperty.getValue());
                }
            }
            if (childs.size() != 0) {
                for (InfoNode child : childs) {
                    this.printNode(child, tabs + 3);
                }
            }
        }
    }
}

