/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.concurrent.future;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.concurrent.future.AbstractFuture;
import org.eclipse.equinox.concurrent.future.FutureProgressMonitor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleOperationFuture<ResultType>
extends AbstractFuture<ResultType> {
    private static final String PLUGIN_ID = "org.eclipse.equinox.concurrent";
    private ResultType resultValue = null;
    private IStatus status = null;
    private TimeoutException timeoutException = null;
    protected IProgressMonitor progressMonitor;

    public SingleOperationFuture() {
        this(null);
    }

    public SingleOperationFuture(IProgressMonitor progressMonitor) {
        this.progressMonitor = new FutureProgressMonitor((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
    }

    @Override
    public synchronized ResultType get() throws InterruptedException, OperationCanceledException {
        this.throwIfCanceled();
        while (!this.isDone()) {
            this.wait();
        }
        this.throwIfCanceled();
        return this.resultValue;
    }

    @Override
    public synchronized ResultType get(long waitTimeInMillis) throws InterruptedException, TimeoutException, OperationCanceledException {
        if (waitTimeInMillis < 0L) {
            throw new IllegalArgumentException("waitTimeInMillis must be => 0");
        }
        this.throwIfCanceled();
        if (this.timeoutException != null) {
            throw this.timeoutException;
        }
        if (this.isDone()) {
            return this.resultValue;
        }
        long startTime = System.currentTimeMillis();
        long waitTime = waitTimeInMillis;
        do {
            this.wait(waitTime);
            this.throwIfCanceled();
            if (!this.isDone()) continue;
            return this.resultValue;
        } while ((waitTime = waitTimeInMillis - (System.currentTimeMillis() - startTime)) > 0L);
        throw this.createTimeoutException(waitTimeInMillis);
    }

    @Override
    public synchronized boolean isDone() {
        return this.status != null;
    }

    @Override
    public void runWithProgress(final IProgressRunnable<?> runnable) {
        Assert.isNotNull(runnable);
        if (!this.isCanceled()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleException(Throwable exception) {
                    SingleOperationFuture singleOperationFuture = SingleOperationFuture.this;
                    synchronized (singleOperationFuture) {
                        if (!SingleOperationFuture.this.isCanceled()) {
                            SingleOperationFuture.this.setException(exception);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    Object result = runnable.run(SingleOperationFuture.this.getProgressMonitor());
                    SingleOperationFuture singleOperationFuture = SingleOperationFuture.this;
                    synchronized (singleOperationFuture) {
                        if (!SingleOperationFuture.this.isCanceled()) {
                            SingleOperationFuture.this.set(result);
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized IStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean hasValue() {
        return this.isDone();
    }

    @Override
    public synchronized boolean cancel() {
        if (this.isDone()) {
            return false;
        }
        if (this.isCanceled()) {
            return false;
        }
        this.setStatus((IStatus)new Status(8, PLUGIN_ID, 8, "Operation canceled", null));
        this.getProgressMonitor().setCanceled(true);
        this.notifyAll();
        return true;
    }

    protected synchronized void setException(Throwable ex) {
        this.setStatus((IStatus)new Status(4, PLUGIN_ID, 4, "Exception during operation", ex));
        this.notifyAll();
    }

    protected synchronized void set(ResultType newValue) {
        this.resultValue = newValue;
        this.setStatus(Status.OK_STATUS);
        this.notifyAll();
    }

    private synchronized void setStatus(IStatus status) {
        this.status = status;
    }

    private TimeoutException createTimeoutException(long timeout) {
        this.setStatus((IStatus)new Status(4, PLUGIN_ID, 4, "Operation timeout after " + timeout + "ms", null));
        this.timeoutException = new TimeoutException("Single operation timeout", timeout);
        return this.timeoutException;
    }

    private void throwIfCanceled() throws OperationCanceledException {
        IProgressMonitor pm = this.getProgressMonitor();
        if (pm != null && pm.isCanceled()) {
            throw new OperationCanceledException("Single operation canceled");
        }
    }

    @Override
    public synchronized IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public synchronized boolean isCanceled() {
        return this.getProgressMonitor().isCanceled();
    }
}

