/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.requirements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Feature;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.base.requirements.BaseFeature;
import org.eclipse.passage.lic.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.base.restrictions.DefaultRestrictionLevel;
import org.eclipse.passage.lic.base.version.DefaultVersion;
import org.eclipse.passage.lic.base.version.SafeVersion;
import org.eclipse.passage.lic.equinox.requirements.BundleName;
import org.eclipse.passage.lic.equinox.requirements.BundleResidentAgreement;
import org.eclipse.passage.lic.equinox.requirements.BundleVendor;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureAgreements;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureId;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureLevel;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureName;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureProvider;
import org.eclipse.passage.lic.equinox.requirements.CapabilityLicFeatureVersion;
import org.eclipse.passage.lic.equinox.requirements.LicCapabilityNamespace;
import org.eclipse.passage.lic.equinox.requirements.ListOfAgreements;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;

final class RequirementFromAttributes
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Bundle bundle;
    private final Map<String, Object> attributes;

    public RequirementFromAttributes(Bundle bundle, Map<String, Object> attributes) {
        this.bundle = bundle;
        this.attributes = attributes;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        Optional feature = new CapabilityLicFeatureId(this.attributes).get();
        if (!feature.isPresent()) {
            return this.fail(NLS.bind((String)EquinoxMessages.RequirementsFromCapability_no_feature_id, (Object)new LicCapabilityNamespace().get(), (Object)new BundleName(this.bundle).get()));
        }
        return this.succeed(this.requirementFromAttributes((FeatureIdentifier)feature.get()));
    }

    private Requirement requirementFromAttributes(FeatureIdentifier feature) {
        String version = new CapabilityLicFeatureVersion(this.attributes).get().map(value -> new SafeVersion(value).value()).orElse(new DefaultVersion().value());
        String name = new CapabilityLicFeatureName(this.attributes).get().orElse(feature.identifier());
        String provider = new CapabilityLicFeatureProvider(this.attributes).get().orElseGet(new BundleVendor(this.bundle));
        RestrictionLevel level = new CapabilityLicFeatureLevel(this.attributes).get().map(RestrictionLevel.Of::new).orElseGet((Supplier<RestrictionLevel>)new DefaultRestrictionLevel());
        Object agreements = new BundleResidentAgreement.Pack(this.bundle, new ListOfAgreements().fromSource(new CapabilityLicFeatureAgreements(this.attributes))).get();
        BaseRequirement requirement = new BaseRequirement((Feature)new BaseFeature(feature, version, name, provider), level, (List)agreements, (Object)this.bundle.getSymbolicName());
        return requirement;
    }

    private ServiceInvocationResult<Collection<Requirement>> fail(String explanation) {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), explanation));
    }

    private ServiceInvocationResult<Collection<Requirement>> succeed(Requirement requirement) {
        return new BaseServiceInvocationResult(Collections.singleton(requirement));
    }
}

