/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.conditions.mining;

import java.util.Objects;
import org.eclipse.passage.lic.api.registry.ServiceId;

public abstract class ContentType
implements ServiceId {
    private final String type;

    public ContentType(String type) {
        Objects.requireNonNull(type, "ContentType::type");
        this.type = this.truncate(type);
    }

    private String truncate(String value) {
        int semicolon = value.indexOf(59);
        return semicolon < 0 ? value : value.substring(0, semicolon);
    }

    public final boolean equals(Object object) {
        if (!ContentType.class.isInstance(object)) {
            return false;
        }
        return this.type.equals(((ContentType)object).contentType());
    }

    public final String contentType() {
        return this.type;
    }

    public final int hashCode() {
        return this.type.hashCode();
    }

    public final String toString() {
        return this.type;
    }

    public static final class Json
    extends ContentType {
        public Json() {
            super("application/json");
        }
    }

    public static final class Of
    extends ContentType {
        public Of(String type) {
            super(type.toLowerCase());
        }
    }

    public static final class Xml
    extends ContentType {
        public Xml() {
            super("text/xml");
        }
    }
}

