/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.e4.ui.addons;

import java.util.Optional;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.restrictions.ExaminationExplained;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.equinox.LicensedProductFromContext;
import org.eclipse.passage.lic.internal.e4.ui.restrictions.WorkbenchShutdown;
import org.eclipse.passage.lic.jface.EquinoxPassageUI;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

public final class E4LicensingAddon {
    private final IApplicationContext application;
    private final IEclipseContext context;
    private Optional<GrantLockAttempt> grant = Optional.empty();

    @Inject
    public E4LicensingAddon(IApplicationContext application, IEclipseContext context) {
        this.application = application;
        this.context = context;
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void applicationStarted(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        ServiceInvocationResult response = new EquinoxPassageUI(this::shell).acquireLicense(new LicensedProductFromContext(this.application).get().identifier());
        if (this.grantAcquired((ServiceInvocationResult<GrantLockAttempt>)response)) {
            this.grant = response.data();
        } else {
            System.err.printf("License grant has not been acquired on startup, shutdown initated: \n%s\n%s\n", new DiagnosticExplained(response.diagnostic()).get(), this.explainExamination((ServiceInvocationResult<GrantLockAttempt>)response));
            new WorkbenchShutdown().run();
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void applicationFainted(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/appShutdownStarted") Event event) {
        this.releaseGrant();
    }

    private Shell shell() {
        return (Shell)this.context.get(Shell.class);
    }

    private boolean grantAcquired(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().isPresent() && ((GrantLockAttempt)response.data().get()).successful();
    }

    private void releaseGrant() {
        if (!this.grant.isPresent()) {
            return;
        }
        ServiceInvocationResult released = new EquinoxPassage().releaseLicense(this.grant.get());
        if (released.data().isPresent() && ((Boolean)released.data().get()).booleanValue()) {
            this.grant = Optional.empty();
        }
    }

    private String explainExamination(ServiceInvocationResult<GrantLockAttempt> response) {
        if (!response.data().isPresent()) {
            return "";
        }
        return new ExaminationExplained(((GrantLockAttempt)response.data().get()).certificate()).get();
    }
}

