/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;

public class Transform
extends Resource {
    double m11;
    double m12;
    double m21;
    double m22;
    double dx;
    double dy;

    public Transform(Device device) {
        super(device);
        this.identity();
    }

    public Transform(Device device, float[] elements) {
        super(device);
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        this.setElements(elements);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        super(device);
        this.setElements(m11, m12, m21, m22, DPIUtil.autoScaleUp((Drawable)device, dx), DPIUtil.autoScaleUp((Drawable)device, dy));
    }

    public void getElements(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        Device drawable = this.getDevice();
        elements[0] = (float)this.m11;
        elements[1] = (float)this.m12;
        elements[2] = (float)this.m21;
        elements[3] = (float)this.m22;
        elements[4] = DPIUtil.autoScaleDown((Drawable)drawable, (float)this.dx);
        elements[5] = DPIUtil.autoScaleDown((Drawable)drawable, (float)this.dy);
    }

    void getElements(double[] elements) {
        elements[0] = this.m11;
        elements[1] = this.m12;
        elements[2] = this.m21;
        elements[3] = this.m22;
        elements[4] = this.dx;
        elements[5] = this.dy;
    }

    public void identity() {
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.dx = 0.0;
        this.dy = 0.0;
    }

    public void invert() {
        double m11 = this.m11;
        double m12 = this.m12;
        double m21 = this.m21;
        double m22 = this.m22;
        double dx = this.dx;
        double dy = this.dy;
        double det = m11 * m22 - m12 * m21;
        if (det == 0.0 || !Double.isFinite(det)) {
            SWT.error(10);
        }
        double dinv = 1.0 / det;
        this.m11 = m22 * dinv;
        this.m12 = -m12 * dinv;
        this.m21 = -m21 * dinv;
        this.m22 = m11 * dinv;
        this.dx = (m21 * dy - m22 * dx) * dinv;
        this.dy = (m12 * dx - m11 * dy) * dinv;
    }

    @Override
    public boolean isDisposed() {
        return this.device == null;
    }

    public boolean isIdentity() {
        return this.m11 == 1.0 && this.m12 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.dx == 0.0 && this.dy == 0.0;
    }

    public void multiply(Transform matrix) {
        if (matrix == null) {
            SWT.error(4);
        }
        double m11 = this.m11;
        double m12 = this.m12;
        double m21 = this.m21;
        double m22 = this.m22;
        double dx = this.dx;
        double dy = this.dy;
        this.m11 = m11 * matrix.m11 + m12 * matrix.m21;
        this.m12 = m11 * matrix.m12 + m12 * matrix.m22;
        this.m21 = m21 * matrix.m11 + m22 * matrix.m21;
        this.m22 = m21 * matrix.m12 + m22 * matrix.m22;
        this.dx = dx * matrix.m11 + dy * matrix.m21 + matrix.dx;
        this.dy = dx * matrix.m12 + dy * matrix.m22 + matrix.dy;
    }

    public void rotate(float angle) {
        double m11 = this.m11;
        double m12 = this.m12;
        double m21 = this.m21;
        double m22 = this.m22;
        double rangle = Math.toRadians(angle);
        double sin = Math.sin(rangle);
        double cos = Math.cos(rangle);
        this.m11 = cos * m11 + sin * m21;
        this.m12 = cos * m12 + sin * m22;
        this.m21 = -sin * m11 + cos * m21;
        this.m22 = -sin * m12 + cos * m22;
    }

    public void scale(float scaleX, float scaleY) {
        this.m11 *= (double)scaleX;
        this.m12 *= (double)scaleX;
        this.m21 *= (double)scaleY;
        this.m22 *= (double)scaleY;
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        Device drawable = this.getDevice();
        this.m11 = m11;
        this.m12 = m12;
        this.m21 = m21;
        this.m22 = m22;
        this.dx = DPIUtil.autoScaleUp((Drawable)drawable, dx);
        this.dy = DPIUtil.autoScaleUp((Drawable)drawable, dy);
    }

    void setElements(float[] elements) {
        this.m11 = elements[0];
        this.m12 = elements[1];
        this.m21 = elements[2];
        this.m22 = elements[3];
        this.dx = elements[4];
        this.dy = elements[5];
    }

    void setElements(double[] elements) {
        this.m11 = elements[0];
        this.m12 = elements[1];
        this.m21 = elements[2];
        this.m22 = elements[3];
        this.dx = elements[4];
        this.dy = elements[5];
    }

    public void shear(float shearX, float shearY) {
        double m11 = this.m11;
        double m12 = this.m12;
        double m21 = this.m21;
        double m22 = this.m22;
        this.m11 += (double)shearY * m21;
        this.m12 += (double)shearY * m22;
        this.m21 += (double)shearX * m11;
        this.m22 += (double)shearX * m12;
    }

    public void transform(float[] pointArray) {
        if (pointArray == null) {
            SWT.error(4);
        }
        int length = pointArray.length;
        Device drawable = this.getDevice();
        int i = 0;
        while (i < length) {
            float x = DPIUtil.autoScaleUp((Drawable)drawable, pointArray[i]);
            float y = DPIUtil.autoScaleUp((Drawable)drawable, pointArray[i + 1]);
            pointArray[i] = DPIUtil.autoScaleDown((Drawable)drawable, (float)((double)x * this.m11 + (double)y * this.m21 + this.dx));
            pointArray[i + 1] = DPIUtil.autoScaleDown((Drawable)drawable, (float)((double)x * this.m12 + (double)y * this.m22 + this.dy));
            i += 2;
        }
    }

    public void translate(float offsetX, float offsetY) {
        Device drawable = this.getDevice();
        float x = DPIUtil.autoScaleUp((Drawable)drawable, offsetX);
        float y = DPIUtil.autoScaleUp((Drawable)drawable, offsetY);
        this.dx += (double)x * this.m11 + (double)y * this.m21;
        this.dy += (double)x * this.m12 + (double)y * this.m22;
    }

    public String toString() {
        return "Transform {" + this.m11 + ", " + this.m12 + ", " + this.m21 + ", " + this.m22 + ", " + this.dx + ", " + this.dy + "}";
    }
}

