/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;

public class Sequential
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;

    public IConstr addAtMost(ISolver solver, IVecInt literals, int k) throws ContradictionException {
        int i;
        ConstrGroup group = new ConstrGroup(false);
        int n = literals.size();
        if (n == 1) {
            return group;
        }
        int[][] s = new int[n - 1][k];
        int j = 0;
        while (j < k) {
            i = 0;
            while (i < n - 1) {
                s[i][j] = solver.nextFreeVarId(true);
                ++i;
            }
            ++j;
        }
        VecInt clause = new VecInt();
        clause.push(-literals.get(0));
        clause.push(s[0][0]);
        group.add(solver.addClause(clause));
        clause.clear();
        int j2 = 1;
        while (j2 < k) {
            clause.push(-s[0][j2]);
            group.add(solver.addClause(clause));
            clause.clear();
            ++j2;
        }
        clause.push(-literals.get(n - 1));
        clause.push(-s[n - 2][k - 1]);
        group.add(solver.addClause(clause));
        clause.clear();
        i = 1;
        while (i < n - 1) {
            clause.push(-literals.get(i));
            clause.push(s[i][0]);
            group.add(solver.addClause(clause));
            clause.clear();
            clause.push(-s[i - 1][0]);
            clause.push(s[i][0]);
            group.add(solver.addClause(clause));
            clause.clear();
            int j3 = 1;
            while (j3 < k) {
                clause.push(-literals.get(i));
                clause.push(-s[i - 1][j3 - 1]);
                clause.push(s[i][j3]);
                group.add(solver.addClause(clause));
                clause.clear();
                clause.push(-s[i - 1][j3]);
                clause.push(s[i][j3]);
                group.add(solver.addClause(clause));
                clause.clear();
                ++j3;
            }
            clause.push(-literals.get(i));
            clause.push(-s[i - 1][k - 1]);
            group.add(solver.addClause(clause));
            clause.clear();
            ++i;
        }
        return group;
    }

    public IConstr addAtMostOne(ISolver solver, IVecInt literals) throws ContradictionException {
        return this.addAtMost(solver, literals, 1);
    }

    public IConstr addExactlyOne(ISolver solver, IVecInt literals) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeastOne(solver, literals));
        group.add(this.addAtMostOne(solver, literals));
        return group;
    }

    public IConstr addExactly(ISolver solver, IVecInt literals, int degree) throws ContradictionException {
        ConstrGroup group = new ConstrGroup();
        group.add(this.addAtLeast(solver, literals, degree));
        group.add(this.addAtMost(solver, literals, degree));
        return group;
    }
}

