/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.oshi;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.passage.lic.api.inspection.EnvironmentProperty;
import org.eclipse.passage.lic.oshi.State;
import org.eclipse.passage.lic.oshi.Swath;

final class GlanceOfState
implements Supplier<String> {
    private final State state;

    GlanceOfState(State state) {
        Objects.requireNonNull(state);
        this.state = state;
    }

    @Override
    public String get() {
        StringBuilder out = new StringBuilder();
        this.state.properties().stream().collect(Collectors.groupingBy(EnvironmentProperty::family)).entrySet().stream().forEach(e -> this.appendFamily((String)e.getKey(), (List)e.getValue(), out));
        this.state.swaths().forEach(swath -> this.appendSwath((Swath<?>)swath, out));
        return out.toString();
    }

    private void appendFamily(String family, List<EnvironmentProperty> properties, StringBuilder out) {
        out.append(family).append("\r\n");
        properties.stream().forEach(p -> {
            StringBuilder stringBuilder2 = this.appendProperty((EnvironmentProperty)p, this.state.value((EnvironmentProperty)p), out);
        });
    }

    private StringBuilder appendProperty(EnvironmentProperty property, String value, StringBuilder out) {
        out.append("\t").append(property.name()).append(": ").append(value).append("\r\n");
        return out;
    }

    private void appendSwath(Swath<?> swath, StringBuilder out) {
        IntStream.range(0, swath.capacity()).forEach(no -> this.appendSwathMember(swath, no, out));
    }

    private void appendSwathMember(Swath<?> swath, int no, StringBuilder out) {
        out.append(swath.family()).append(" #").append(no).append("\r\n");
        swath.properties(no).stream().forEach(p -> {
            StringBuilder stringBuilder2 = this.appendProperty((EnvironmentProperty)p, swath.value(no, (EnvironmentProperty)p), out);
        });
    }
}

