/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Fields;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.SwitchField;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;

public final class SwitchableFields
implements Fields {
    private final Fields dependants;
    private final Field<Boolean> switcher;
    private MandatoryService context;
    private LabelProvider labels;

    SwitchableFields(IEclipseContext context, String name, boolean value, Fields dependants) {
        this.context = new MandatoryEclipseContext(context);
        this.labels = new DomainRegistryLabelProvider();
        this.dependants = dependants;
        this.switcher = new SwitchField(name, value, this::modified, this.labels, this.context);
    }

    @Override
    public List<Field<?>> fields() {
        return Collections.singletonList(this.switcher);
    }

    @Override
    public final void modified() {
        this.enableDependants();
        this.dependants.modified();
    }

    public Supplier<Optional<Boolean>> switcher() {
        return this.switcher::data;
    }

    private void enableDependants() {
        Boolean enable = this.switcher.data().get();
        this.dependants.fields().forEach(field -> field.enable(enable));
    }
}

