/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.user;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.FloatingLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.LicenseRequisitesDescriptor;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserOriginDescriptor;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.users.UserRegistry;
import org.eclipse.passage.loc.report.internal.core.user.CustomerStorage;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class Customers
implements CustomerStorage {
    private UserRegistry users;
    private LicenseRegistry licenses;

    @Override
    public Set<UserDescriptor> personsUsedProducts(Set<String> products) {
        return this.licenses.getLicensePlans().stream().map(plan -> this.licenses(plan.getPersonal(), products, PersonalLicensePackDescriptor::getLicense)).flatMap(Collection::stream).map(this::user).distinct().map(arg_0 -> ((UserRegistry)this.users).getUser(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public Set<UserOriginDescriptor> companiesUsedProducts(Set<String> products) {
        return this.licenses.getLicensePlans().stream().map(plan -> this.licenses(plan.getFloating(), products, FloatingLicensePackDescriptor::getLicense)).flatMap(Collection::stream).map(this::company).distinct().map(arg_0 -> ((UserRegistry)this.users).getUserOrigin(arg_0)).collect(Collectors.toSet());
    }

    @Override
    public Set<String> products() {
        return this.licenses.getLicensePlans().stream().map(LicensePlanDescriptor::getPersonal).flatMap(Collection::stream).map(this::product).collect(Collectors.toSet());
    }

    @Reference
    public void installUserRegistry(UserRegistry registry) {
        this.users = registry;
    }

    @Reference
    public void installLicensesRegistry(LicenseRegistry registry) {
        this.licenses = registry;
    }

    private <T> Set<T> licenses(Collection<T> packs, Set<String> products, Function<T, LicenseRequisitesDescriptor> license) {
        return packs.stream().filter(pack -> this.forProduct((LicenseRequisitesDescriptor)license.apply(pack), products)).collect(Collectors.toSet());
    }

    private boolean forProduct(LicenseRequisitesDescriptor lic, Set<String> products) {
        return products.contains(lic.getProduct().getIdentifier());
    }

    private String user(PersonalLicensePackDescriptor pack) {
        return pack.getLicense().getUser().getIdentifier();
    }

    private String company(FloatingLicensePackDescriptor pack) {
        return pack.getLicense().getCompany().getIdentifier();
    }

    private String product(PersonalLicensePackDescriptor pack) {
        return pack.getLicense().getProduct().getIdentifier();
    }
}

