/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.Condition;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.ValidityPeriod;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.base.conditions.BaseValidityPeriodClosed;
import org.eclipse.passage.lic.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.equinox.EquinoxPassage;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.equinox.access.RegisteredLibraries;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AllConditionsFromLicenses;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AllLicensesFromFolder;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.LicenseSet;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.i18n.ImportLicenseDialogMessages;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ImportLicenseDialog
extends NotificationDialog {
    private final DateTimeFormatter dates = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private Libraries libraries = null;
    private ButtonConfig action;
    private Text path;

    public ImportLicenseDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ImportLicenseDialogMessages.ImportLicenseDialog_title);
        shell.setImage(LicensingImages.getImage("IMG_IMPORT"));
        shell.setSize(850, 500);
    }

    @Override
    protected void buildUI(Composite parent) {
        this.buildSelector(parent);
        this.buildViewer(parent);
    }

    @Override
    protected void initMessage() {
        this.setMessage(ImportLicenseDialogMessages.ImportLicenseDialog_prelude);
    }

    private void buildSelector(Composite parent) {
        Composite composite = this.row(parent, 3);
        new Label(composite, 0).setText(ImportLicenseDialogMessages.ImportLicenseDialog_path_label);
        this.path = new Text(composite, 2056);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browse = new Button(composite, 8);
        browse.setText(ImportLicenseDialogMessages.ImportLicenseDialog_browse);
        browse.addListener(13, e -> this.browseAndLoad());
        this.setButtonLayoutData(browse);
    }

    private Composite row(Composite parent, int columns) {
        Composite row = new Composite(parent, 0);
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        row.setLayout((Layout)new GridLayout(columns, false));
        return row;
    }

    private void buildViewer(Composite parent) {
        this.viewer = new HereTable<Condition>(parent, Condition.class).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_feature, 300, this::feature).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_period, 300, this::period).withColumn(ImportLicenseDialogMessages.ImportLicenseDialog_column_evaluation, 210, this::evaluation).viewer();
    }

    private String feature(Condition condition) {
        return String.format("%s version %s (%s)", condition.feature(), condition.versionMatch().version(), condition.versionMatch().rule().identifier());
    }

    private String period(Condition condition) {
        ValidityPeriod period = condition.validityPeriod();
        if (!BaseValidityPeriodClosed.class.isInstance(period)) {
            return "unknown";
        }
        BaseValidityPeriodClosed closed = (BaseValidityPeriodClosed)condition.validityPeriod();
        return String.format("%s - %s", this.dates.format(closed.from()), this.dates.format(closed.to()));
    }

    private String evaluation(Condition condition) {
        return String.format("%s (%s)", condition.evaluationInstructions().expression(), condition.evaluationInstructions().type().identifier());
    }

    private void browseAndLoad() {
        this.loadLicense(this.browse());
        this.updateButtonsEnablement();
    }

    private List<Path> browse() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10001000);
        dialog.setText(ImportLicenseDialogMessages.ImportLicenseDialog_browse_dialog_title);
        String folder = dialog.open();
        if (folder == null) {
            return Collections.emptyList();
        }
        this.path.setText(folder);
        Object licenses = new AllLicensesFromFolder(folder).get();
        this.path.setData(licenses);
        return licenses;
    }

    private void loadLicense(List<Path> files) {
        Optional<LicensedProduct> product = this.product();
        if (!product.isPresent()) {
            return;
        }
        ServiceInvocationResult<Collection<ConditionPack>> packs = new AllConditionsFromLicenses(files, this.libraries()).get();
        if (!new NoSevereErrors().test(packs.diagnostic())) {
            this.reportError(packs.diagnostic());
            return;
        }
        List conditions = ((Collection)packs.data().get()).stream().flatMap(pack -> pack.conditions().stream()).collect(Collectors.toList());
        this.viewer.setInput(conditions);
    }

    private void reportError(Diagnostic diagnostic) {
        this.setErrorMessage(ImportLicenseDialogMessages.ImportLicenseDialog_lic_read_failed);
        new DiagnosticDialog(this.getShell(), diagnostic).open();
    }

    @Override
    protected void initButtons() {
        this.action = new ButtonConfig(1, this::doLicenseImport, ImportLicenseDialogMessages.ImportLicenseDialog_import_title, ImportLicenseDialogMessages.ImportLicenseDialog_import_tooltip, "");
        this.action.reside(this.buttons);
    }

    @Override
    protected void inplaceData() {
        this.viewer.setInput(Collections.emptyList());
    }

    @Override
    protected void updateButtonsEnablement() {
        this.getButton(this.action.id()).setEnabled(!((Collection)this.viewer.getInput()).isEmpty());
    }

    private Optional<LicensedProduct> product() {
        ServiceInvocationResult product = new EquinoxPassage().product();
        if (!product.data().isPresent()) {
            this.reportError(product.diagnostic());
        }
        return product.data();
    }

    private void doLicenseImport() {
        Optional<LicensedProduct> product = this.product();
        if (!product.isPresent()) {
            return;
        }
        Object licenses = this.path.getData();
        if (licenses == null) {
            return;
        }
        new LicenseSet((List)licenses, product.get(), this.libraries, arg_0 -> ((ImportLicenseDialog)this).setErrorMessage(arg_0)).install();
        this.okPressed();
    }

    private Libraries libraries() {
        if (this.libraries == null) {
            Optional<LicensedProduct> product = this.product();
            if (!product.isPresent()) {
                return null;
            }
            this.libraries = new Libraries((Supplier)new RegisteredLibraries(), product::get);
        }
        return this.libraries;
    }
}

