/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.requirements;

import java.util.Objects;
import org.eclipse.passage.lic.api.requirements.Feature;

public final class BaseFeature
implements Feature {
    private final String id;
    private final String version;
    private final String name;
    private final String provider;

    public BaseFeature(String id, String version, String name, String provider) {
        Objects.requireNonNull(id, "Identifier is mandatory for a feature");
        Objects.requireNonNull(version, "Version is mandatory for a feature");
        Objects.requireNonNull(name, "Name is mandatory for a feature");
        Objects.requireNonNull(provider, "Provider is mandatory for a feature");
        this.id = id;
        this.version = version;
        this.name = name;
        this.provider = provider;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String identifier() {
        return this.id;
    }

    public String provider() {
        return this.provider;
    }

    public boolean equals(Object another) {
        if (!this.getClass().isInstance(another)) {
            return false;
        }
        Feature feature = (Feature)another;
        return this.id.equals(feature.identifier()) && this.name.equals(feature.name()) && this.version.equals(feature.version()) && this.provider.equals(feature.provider());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.id, this.provider);
    }

    public String toString() {
        return "BaseFeature [id=" + this.id + ", version=" + this.version + ", name=" + this.name + ", provider=" + this.provider + "]";
    }
}

