/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class LicenseDataPage
extends WizardPage {
    private final List<Field<?>> units;
    private final String description;

    protected LicenseDataPage(String name, String description, List<Field<?>> units) {
        super(name);
        this.description = description;
        this.units = units;
        this.setTitle(IssueLicensePageMessages.IssueLicenseRequestPage_page_title);
        this.installDefaultMessage();
    }

    public void createControl(Composite parent) {
        Composite container = this.container(parent);
        this.setControl((Control)container);
        this.units.forEach(unit -> unit.installControll(container));
        Dialog.applyDialogFont((Control)container);
    }

    private Composite container(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        return container;
    }

    void validate() {
        this.setPageComplete(this.validatePage());
    }

    private boolean validatePage() {
        this.installDefaultMessage();
        for (Field<?> unit : this.units) {
            Optional<String> error = unit.errorIfAny();
            if (!error.isPresent()) continue;
            this.setMessage(error.get(), 3);
            return false;
        }
        return true;
    }

    private void installDefaultMessage() {
        this.setMessage(this.description, 0);
    }
}

