/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.DateField;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.Field;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.swt.widgets.Composite;

final class ActivePeriodField
implements Field<List<LocalDate>> {
    private final DateField from;
    private final DateField until;

    ActivePeriodField(Runnable modified, LabelProvider labels, MandatoryService context) {
        this.from = new DateField(LocalDate.now(), IssueLicensePageMessages.IssueLicenseRequestPage_lbl_valid_from, modified, labels, context);
        this.until = new DateField(LocalDate.now().plusYears(1L), IssueLicensePageMessages.IssueLicenseRequestPage_lbl_valid_until, modified, labels, context);
    }

    @Override
    public void installControll(Composite parent) {
        this.from.installControll(parent);
        this.until.installControll(parent);
    }

    @Override
    public Optional<List<LocalDate>> data() {
        Optional start = this.from.data();
        Optional end = this.until.data();
        return !start.isPresent() || !end.isPresent() ? Optional.empty() : Optional.of(Arrays.asList((LocalDate)start.get(), (LocalDate)end.get()));
    }

    @Override
    public Optional<String> errorIfAny() {
        Optional start = this.from.error();
        if (start.isPresent()) {
            return start;
        }
        Optional end = this.until.error();
        if (end.isPresent()) {
            return end;
        }
        if (((LocalDate)this.from.data().get()).isAfter((ChronoLocalDate)this.until.data().get())) {
            return Optional.of(IssueLicensePageMessages.IssueLicenseRequestPage_e_reversed_period);
        }
        return Optional.empty();
    }

    @Override
    public void enable(boolean enable) {
        this.from.enable(enable);
        this.until.enable(enable);
    }
}

