/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.nio.file.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.loc.internal.api.IssuedFloatingLicense;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.internal.licenses.ui.i18n.LicensesUiMessages;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;

public final class LicenseIssuedNotification {
    private final Shell shell;

    public LicenseIssuedNotification(Shell shell) {
        this.shell = shell;
    }

    public void showPersonal(IssuedLicense license) {
        this.show(IssueLicensePageMessages.IssueLicenseWizard_ok_licensed_title, String.format(LicensesUiMessages.LicenseExportHandler_success_description, license.encrypted().toAbsolutePath().toString(), license.decrypted().toAbsolutePath().toString()), license.encrypted().getParent());
    }

    public void showFloating(IssuedFloatingLicense license) {
        this.show(IssueLicensePageMessages.IssueFloatingLicenseWizard_success, String.format(IssueLicensePageMessages.IssueFloatingLicenseWizard_success_description, license.residence().toAbsolutePath()), license.residence());
    }

    private void show(String title, String description, Path residence) {
        MessageDialog dialog = new MessageDialog(this.shell, title, null, description, 2, new String[]{"OK", "Open &Folder"}, 0);
        int result = dialog.open();
        if (result == 1) {
            Program.launch((String)residence.toAbsolutePath().toString());
        }
    }
}

