/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lic.floating.model.api.GrantAcqisition;
import org.eclipse.passage.lic.internal.api.LicensedProduct;

public abstract class Failure
implements FloatingResponse {
    private final int code;
    private final String message;

    protected Failure(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public boolean failed() {
        return true;
    }

    public boolean carriesPayload() {
        return false;
    }

    public FloatingResponse.Error error() {
        return new Err();
    }

    public byte[] payload() {
        throw new IllegalStateException("Is not intended to be called for failed response: no valid output");
    }

    public static final class BadRequestInvalidProduct
    extends Failure {
        public BadRequestInvalidProduct() {
            super(604, "Bad Request: licensed product identifier and/or version information is absent");
        }
    }

    public static final class BadRequestInvalidServerAuthInstructions
    extends Failure {
        public BadRequestInvalidServerAuthInstructions() {
            super(602, "Bad Requets: floating server authentication instructions (evaluation type and exrpressions) are absent or incomplete");
        }
    }

    public static final class BadRequestNoFeature
    extends Failure {
        public BadRequestNoFeature() {
            super(606, "Bad Request: no feature identifier");
        }
    }

    public static final class BadRequestNoUser
    extends Failure {
        public BadRequestNoUser() {
            super(605, "Bad Request: no user identifier");
        }
    }

    public static final class BadRequestUnknownAction
    extends Failure {
        public BadRequestUnknownAction(String actual) {
            super(603, String.format("Bad Requets: 'action' %s is not supported", actual));
        }
    }

    private final class Err
    implements FloatingResponse.Error {
        private Err() {
        }

        public int code() {
            return Failure.this.code;
        }

        public String message() {
            return Failure.this.message;
        }
    }

    public static final class ForeignServer
    extends Failure {
        public ForeignServer(String error) {
            super(600, String.format("Server authentication failed: %s", error));
        }
    }

    public static final class NoGrantsAvailable
    extends Failure {
        public NoGrantsAvailable(LicensedProduct product, String feature) {
            super(611, String.format("No license grants available for feature %s of product %s", feature, product));
        }
    }

    public static final class NotReleased
    extends Failure {
        public NotReleased(LicensedProduct product, GrantAcqisition acqisition) {
            super(612, String.format("Failed to release grant %s acquisition for feature %s of product %s", acqisition.getGrant(), acqisition.getFeature(), product));
        }
    }

    public static final class OperationFailed
    extends Failure {
        public OperationFailed(String name, String details) {
            super(610, String.format("Operation %s failed: \n%s", name, details));
        }
    }
}

