/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.email.EmailDescriptor;
import org.eclipse.passage.lic.email.Mailing;
import org.eclipse.passage.lic.licenses.LicenseGrantDescriptor;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;

public class EmailTemplate {
    private final String separator = "%0A";
    private final String dotEml = ".eml";
    private final Mailing mailing;

    public EmailTemplate(Mailing mailing) {
        Objects.requireNonNull(mailing);
        this.mailing = mailing;
    }

    public List<String> details(LicensePackDescriptor licensePack) {
        ArrayList<String> builder = new ArrayList<String>();
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_request_lbl, (Object)licensePack.getRequestIdentifier()));
        builder.add("");
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_plan_lbl, (Object)licensePack.getPlanIdentifier()));
        Optional.ofNullable(licensePack.getIdentifier()).ifPresent(x -> {
            boolean bl = builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_package_lbl, (Object)x));
        });
        builder.add("");
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_product_lbl, (Object)licensePack.getProductIdentifier()));
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_product_version_lbl, (Object)licensePack.getProductVersion()));
        for (LicenseGrantDescriptor grant : licensePack.getLicenseGrants()) {
            builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_feature_lbl, (Object)grant.getFeatureIdentifier()));
            String conditionExpression = grant.getConditionExpression();
            if (conditionExpression == null || conditionExpression.isEmpty()) continue;
            builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_condition_expr_lbl, (Object)conditionExpression));
        }
        builder.add("");
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_user_lbl, (Object)licensePack.getUserIdentifier()));
        builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_user_name_lbl, (Object)licensePack.getUserFullName()));
        builder.add("");
        Optional.ofNullable(licensePack.getIssueDate()).ifPresent(x -> {
            boolean bl = builder.add(NLS.bind((String)LicensesCoreMessages.LicenseRequest_issue_date_lbl, (Object)x));
        });
        builder.add("");
        return builder;
    }

    public String mailTo(LicensePackDescriptor licensePack) {
        StringBuilder builder = new StringBuilder("mailto:");
        builder.append(licensePack.getUserIdentifier());
        builder.append("?subject=");
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_subject_lbl);
        builder.append("&body=");
        builder.append(NLS.bind((String)LicensesCoreMessages.LicenseRequest_mailto_appeal_lbl, (Object)licensePack.getUserFullName()));
        builder.append("%0A");
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_body_base_lbl);
        builder.append("%0A").append("%0A");
        builder.append(LicensesCoreMessages.LicenseRequest_mailto_body_details_lbl);
        builder.append("%0A");
        builder.append(this.details(licensePack).stream().collect(Collectors.joining("%0A")));
        return builder.toString();
    }

    public File createEmlFile(String from, LicensePackDescriptor licensePack, IssuedLicense result) throws IOException {
        File attachment = result.encrypted().toFile();
        File emlFile = new File(String.valueOf(attachment.toString()) + ".eml");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream stream = new FileOutputStream(emlFile);){
                Mailing service = this.mailing;
                EmailDescriptor descriptor = service.createMail(licensePack.getUserIdentifier(), from, LicensesCoreMessages.LicenseRequest_mailto_subject_lbl, this.details(licensePack).stream().collect(Collectors.joining(System.lineSeparator())), Collections.singleton(attachment.getPath()));
                service.writeEml(descriptor, (OutputStream)stream, (BiConsumer)new BiConsumer<String, Throwable>(){

                    @Override
                    public void accept(String message, Throwable t) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, message, t);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        return emlFile;
    }
}

