/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.hc.remote.Connection;

public final class NetConnection
implements Connection {
    private final HttpURLConnection connection;

    NetConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public void beGet() throws LicensingException {
        this.invoke(() -> this.connection.setRequestMethod("GET"));
        this.connection.setDoOutput(false);
        this.connection.setDoInput(true);
    }

    @Override
    public void bePost() throws LicensingException {
        this.invoke(() -> this.connection.setRequestMethod("POST"));
        this.connection.setDoOutput(true);
        this.connection.setDoInput(true);
    }

    @Override
    public void withTimeout(int timeout) {
        this.connection.setConnectTimeout(timeout);
    }

    @Override
    public void withProperty(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    public void withPayload(byte[] payload) throws LicensingException {
        this.invoke(() -> this.write(payload));
    }

    @Override
    public boolean successful() throws LicensingException {
        return this.code() == 200;
    }

    @Override
    public int code() throws LicensingException {
        return this.invoke(this.connection::getResponseCode);
    }

    @Override
    public String message() throws LicensingException {
        return this.invoke(this.connection::getResponseMessage);
    }

    @Override
    public ContentType contentType() throws LicensingException {
        return new ContentType.Of(this.connection.getContentType());
    }

    @Override
    public byte[] payload() throws LicensingException {
        return this.invoke(this::read);
    }

    private void write(byte[] payload) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream output = this.connection.getOutputStream();){
            output.write(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private byte[] read() throws Exception {
        byte[] content = new byte[this.connection.getContentLength()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream source = this.connection.getInputStream();){
            source.read(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return content;
    }

    private void invoke(Failable method) throws LicensingException {
        try {
            method.invoke();
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    private <T> T invoke(FailableWithResult<T> action) throws LicensingException {
        try {
            return action.invoke();
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    private static interface Failable {
        public void invoke() throws Exception;
    }

    private static interface FailableWithResult<T> {
        public T invoke() throws Exception;
    }
}

